/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructField;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@StructureMapping(structureName="runtime.structtype")
public class GoStructType
extends GoType {
    @FieldMapping
    @MarkupReference
    private long pkgPath;
    @FieldMapping
    private GoSlice fields;

    @Markup
    public GoName getPkgPath() throws IOException {
        return this.programContext.getGoName(this.pkgPath);
    }

    public String getPkgPathString() throws IOException {
        GoName n = this.getPkgPath();
        return n != null ? n.getName() : "";
    }

    public List<GoStructField> getFields() throws IOException {
        return this.fields.readList(GoStructField.class);
    }

    @Override
    public void additionalMarkup() throws IOException {
        super.additionalMarkup();
        this.fields.markupArray(this.getStructureLabel() + "_fields", GoStructField.class, false);
        this.fields.markupArrayElements(GoStructField.class);
    }

    @Override
    public String getTypeDeclString() throws IOException {
        Object methodListStr = this.getMethodListString();
        methodListStr = methodListStr == null || ((String)methodListStr).isEmpty() ? "// No methods" : "// Methods\n" + (String)methodListStr;
        return "// size: %d\ntype %s struct {\n%s\n%s\n}\n".formatted(this.typ.getSize(), this.typ.getNameString(), this.getFieldListString().indent(2), ((String)methodListStr).indent(2));
    }

    private String getFieldListString() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (GoStructField field : this.getFields()) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            long offset = field.getOffset();
            long fieldSize = field.getType().getBaseType().getSize();
            sb.append("%s %s // %d..%d".formatted(field.getNameString(), field.getType().getBaseType().getNameString(), offset, offset + fieldSize));
        }
        return sb.toString();
    }

    @Override
    public DataType recoverDataType() throws IOException {
        StructureDataType struct = new StructureDataType(this.programContext.getRecoveredTypesCp(), this.typ.getNameString(), (int)this.typ.getSize(), this.programContext.getDTM());
        this.programContext.cacheRecoveredDataType(this, (DataType)struct);
        ArrayList<GoStructField> skippedFields = new ArrayList<GoStructField>();
        List<GoStructField> fieldList = this.getFields();
        for (int i = 0; i < fieldList.size(); ++i) {
            GoStructField field = fieldList.get(i);
            GoStructField nextField = i < fieldList.size() - 1 ? fieldList.get(i + 1) : null;
            long availSpace = nextField != null ? nextField.getOffset() - field.getOffset() : this.typ.getSize() - field.getOffset();
            GoType fieldType = field.getType();
            long fieldSize = fieldType.getBaseType().getSize();
            if (fieldSize == 0L) {
                skippedFields.add(field);
                continue;
            }
            try {
                DataType fieldDT = this.programContext.getRecoveredType(fieldType);
                struct.replaceAtOffset((int)field.getOffset(), fieldDT, (int)fieldSize, field.getNameString(), null);
                continue;
            }
            catch (IllegalArgumentException e) {
                Msg.warn((Object)this, (Object)"Failed to add field to go recovered struct: %s".formatted(this.getDebugId()), (Throwable)e);
            }
        }
        for (GoStructField skippedField : skippedFields) {
            DataTypeComponent dtc = struct.getDefinedComponentAtOrAfterOffset((int)skippedField.getOffset());
            GoType skippedFieldType = skippedField.getType();
            if (dtc == null) continue;
            Object comment = dtc.getComment();
            comment = comment == null ? "" : (String)comment + "\n";
            comment = (String)comment + "Omitted zero-len field: %s=%s".formatted(skippedField.getNameString(), skippedFieldType.getBaseType().getNameString());
            dtc.setComment((String)comment);
        }
        DWARFUtil.packCompositeIfPossible((Composite)struct, this.programContext.getDTM());
        return struct;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        for (GoStructField field : this.getFields()) {
            field.getType().discoverGoTypes(discoveredTypes);
        }
        return true;
    }
}

