/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName="runtime.ptrtype")
public class GoPointerType
extends GoType {
    @FieldMapping
    @MarkupReference(value="element")
    private long elem;

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoType(this.elem);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        DataType elementDT = this.programContext.getRecoveredType(this.getElement());
        DataType self = this.programContext.getCachedRecoveredDataType(this);
        if (self != null) {
            return self;
        }
        return new PointerDataType(elementDT, this.programContext.getDTM());
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType element = this.getElement();
        if (element != null) {
            element.discoverGoTypes(discoveredTypes);
        }
        return true;
    }
}

