/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.model.address.Address;
import java.io.IOException;

@StructureMapping(structureName="runtime.method")
public class GoMethod
implements StructureMarkup<GoMethod> {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoMethod> context;
    @FieldMapping
    @MarkupReference
    @EOLComment(value="nameString")
    private long name;
    @FieldMapping
    @MarkupReference(value="type")
    private long mtyp;
    @FieldMapping
    @MarkupReference
    private long ifn;
    @FieldMapping
    @MarkupReference
    private long tfn;

    @Markup
    public GoName getName() throws IOException {
        return this.programContext.resolveNameOff(this.context.getStructureStart(), this.name);
    }

    public String getNameString() throws IOException {
        GoName n = this.getName();
        return n != null ? n.getName() : "_blank_";
    }

    @Markup
    public GoType getType() throws IOException {
        return this.programContext.resolveTypeOff(this.context.getStructureStart(), this.mtyp);
    }

    @Override
    public StructureContext<GoMethod> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureName() throws IOException {
        return this.getNameString();
    }

    public Address getIfn() {
        return this.programContext.resolveTextOff(this.context.getStructureStart(), this.ifn);
    }

    public Address getTfn() {
        return this.programContext.resolveTextOff(this.context.getStructureStart(), this.tfn);
    }
}

