/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.types.GoKind;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.rtti.types.GoTypeFlag;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.Signedness;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName="runtime._type")
public class GoBaseType {
    @ContextField
    private StructureContext<GoBaseType> context;
    @ContextField
    private GoRttiMapper programContext;
    @FieldMapping(signedness=Signedness.Unsigned)
    private long size;
    @FieldMapping
    private long ptrdata;
    @FieldMapping
    @EOLComment(value="flags")
    private int tflag;
    @FieldMapping
    @EOLComment
    private int kind;
    @FieldMapping
    @MarkupReference(value="name")
    private long str;
    @FieldMapping
    @MarkupReference
    private long ptrToThis;

    public long getSize() {
        return this.size;
    }

    public GoKind getKind() {
        return GoKind.parseByte(this.kind);
    }

    public Set<GoTypeFlag> getFlags() {
        return GoTypeFlag.parseFlags(this.tflag);
    }

    public int getTflag() {
        return this.tflag;
    }

    public boolean hasUncommonType() {
        return GoTypeFlag.Uncommon.isSet(this.tflag);
    }

    @Markup
    public GoName getName() throws IOException {
        return this.programContext.resolveNameOff(this.context.getStructureStart(), this.str);
    }

    public String getNameString() throws IOException {
        String s = this.getName().getName();
        return GoTypeFlag.ExtraStar.isSet(this.tflag) ? s.substring(1) : s;
    }

    @Markup
    public GoType getPtrToThis() throws IOException {
        return this.programContext.resolveTypeOff(this.context.getStructureStart(), this.ptrToThis);
    }
}

