/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.address.Address;
import java.io.IOException;

@StructureMapping(structureName="runtime.functab")
public class GoFunctabEntry {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoFunctabEntry> context;
    @FieldMapping
    @MarkupReference(value="funcAddress")
    private long entryoff;
    @FieldMapping
    @MarkupReference(value="funcData")
    private long funcoff;

    public Address getFuncAddress() {
        return this.getModuledata().getText().add(this.entryoff);
    }

    @Markup
    public GoFuncData getFuncData() throws IOException {
        return this.funcoff != 0L ? this.getModuledata().getFuncDataInstance(this.funcoff) : null;
    }

    private GoModuledata getModuledata() {
        return this.programContext.findContainingModuleByFuncData(this.context.getStructureStart());
    }
}

