/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

@StructureMapping(structureName="runtime._func")
public class GoFuncData
implements StructureMarkup<GoFuncData> {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoFuncData> context;
    @FieldMapping
    @EOLComment(value="description")
    @MarkupReference(value="funcAddress")
    private long entryoff;
    @FieldMapping
    @MarkupReference(value="nameAddress")
    private long nameoff;

    public Address getFuncAddress() {
        return this.getModuledata().getText().add(this.entryoff);
    }

    public Address getNameAddress() {
        return this.getModuledata().getFuncnametab().getArrayAddress().add(this.nameoff);
    }

    public String getName() throws IOException {
        BinaryReader reader = this.programContext.getReader(this.getModuledata().getFuncnametab().getArrayOffset() + this.nameoff);
        return reader.readNextUtf8String();
    }

    public String getDescription() throws IOException {
        return this.getName() + "@" + this.getFuncAddress();
    }

    public boolean isInline() {
        return this.entryoff == -1L || this.entryoff == 0xFFFFFFFFL;
    }

    private GoModuledata getModuledata() {
        return this.programContext.findContainingModuleByFuncData(this.context.getStructureStart());
    }

    @Override
    public StructureContext<GoFuncData> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureName() throws IOException {
        return this.getName();
    }

    @Override
    public void additionalMarkup() throws IOException {
        Address addr = this.getFuncAddress();
        String name = SymbolUtilities.replaceInvalidChars((String)this.getName(), (boolean)true);
        Program program = this.programContext.getProgram();
        Function function = program.getListing().getFunctionAt(addr);
        if (function == null) {
            try {
                if (!program.getMemory().getLoadedAndInitializedAddressSet().contains(addr)) {
                    Msg.warn((Object)this, (Object)"Unable to create function not contained within loaded memory: %s@%s".formatted(name, addr));
                    return;
                }
                function = program.getFunctionManager().createFunction(name, addr, (AddressSetView)new AddressSet(addr), SourceType.IMPORTED);
            }
            catch (OverlappingFunctionException | InvalidInputException e) {
                Msg.error((Object)this, (Object)e);
            }
        } else {
            this.programContext.labelAddress(addr, name);
        }
    }
}

