/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.golang.GoBuildSettings;
import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.app.util.bin.format.golang.GoModuleInfo;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.LEB128;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoBuildInfo
implements ElfInfoItem {
    public static final String SECTION_NAME = ".go.buildinfo";
    private static final byte[] GO_BUILDINF_MAGIC = "\u00ff Go buildinf:".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] INFOSTART_SENTINEL = NumericUtilities.convertStringToBytes((String)"3077af0c9274080241e1c107e6d618e6");
    private static final byte[] INFOEND_SENTINEL = NumericUtilities.convertStringToBytes((String)"f932433186182072008242104116d8f2");
    private static final int FLAG_ENDIAN = 1;
    private static final int FLAG_INLINE_STRING = 2;
    private final int pointerSize;
    private final Endian endian;
    private final String version;
    private final String path;
    private final GoModuleInfo moduleInfo;
    private final List<GoModuleInfo> dependencies;
    private final List<GoBuildSettings> buildSettings;

    public static GoBuildInfo fromProgram(Program program) {
        ElfInfoItem.ItemWithAddress<GoBuildInfo> wrappedItem = GoBuildInfo.findBuildInfo(program);
        return wrappedItem != null ? wrappedItem.item() : null;
    }

    public static ElfInfoItem.ItemWithAddress<GoBuildInfo> findBuildInfo(Program program) {
        ElfInfoItem.ItemWithAddress<GoBuildInfo> wrappedItem = ElfInfoItem.readItemFromSection(program, SECTION_NAME, GoBuildInfo::read);
        if (wrappedItem == null) {
            wrappedItem = ElfInfoItem.readItemFromSection(program, ".data", GoBuildInfo::read);
        }
        return wrappedItem;
    }

    public static GoBuildInfo read(BinaryReader reader, Program program) throws IOException {
        boolean inlineStr;
        byte[] magicBytes = reader.readNextByteArray(GO_BUILDINF_MAGIC.length);
        if (!Arrays.equals(magicBytes, GO_BUILDINF_MAGIC)) {
            throw new IOException("Missing GoBuildInfo magic");
        }
        int pointerSize = reader.readNextUnsignedByte();
        int flags = reader.readNextUnsignedByte();
        Endian endian = (flags & 1) == 0 ? Endian.LITTLE : Endian.BIG;
        boolean bl = inlineStr = (flags & 2) != 0;
        if (reader.isBigEndian() && endian != Endian.BIG) {
            throw new IOException("Mixed endian-ness");
        }
        return GoBuildInfo.readStringInfo(reader, inlineStr, program, pointerSize);
    }

    public static boolean isPresent(InputStream is) {
        try {
            byte[] buffer = new byte[GO_BUILDINF_MAGIC.length];
            int bytesRead = is.read(buffer);
            return bytesRead == GO_BUILDINF_MAGIC.length && Arrays.equals(buffer, GO_BUILDINF_MAGIC);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public GoBuildInfo(int pointerSize, Endian endian, String version, String path, GoModuleInfo moduleInfo, List<GoModuleInfo> dependencies, List<GoBuildSettings> buildSettings) {
        this.pointerSize = pointerSize;
        this.endian = endian;
        this.version = version;
        this.path = path;
        this.moduleInfo = moduleInfo;
        this.dependencies = dependencies;
        this.buildSettings = buildSettings;
    }

    public int getPointerSize() {
        return this.pointerSize;
    }

    public Endian getEndian() {
        return this.endian;
    }

    public String getVersion() {
        return this.version;
    }

    public GoVer getVerEnum() {
        return GoVer.parse(this.version);
    }

    public String getPath() {
        return this.path;
    }

    public GoModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public List<GoModuleInfo> getDependencies() {
        return this.dependencies;
    }

    public List<GoBuildSettings> getBuildSettings() {
        return this.buildSettings;
    }

    @Override
    public void markupProgram(Program program, Address address) {
        this.decorateProgramInfo(program.getOptions("Program Information"));
        try {
            StructureDataType struct = this.toStructure((DataTypeManager)program.getDataTypeManager());
            if (struct != null) {
                DataUtilities.createData((Program)program, (Address)address, (DataType)struct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
            }
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)"Failed to markup GoBuildInfo at %s: %s".formatted(address, this));
        }
    }

    public void decorateProgramInfo(Options props) {
        GoVer.setProgramPropertiesWithOriginalVersionString(props, this.getVersion());
        props.setString("Golang app path", this.getPath());
        if (this.getModuleInfo() != null) {
            this.getModuleInfo().asKeyValuePairs("Golang main package ").entrySet().stream().forEach(entry -> props.setString((String)entry.getKey(), (String)entry.getValue()));
        }
        int depNum = 0;
        for (GoModuleInfo dep : this.getDependencies()) {
            String key = "Golang dep[%4d]".formatted(depNum++);
            props.setString(key, dep.getFormattedString());
        }
        for (GoBuildSettings buildSetting : this.getBuildSettings()) {
            props.setString("Golang build[" + buildSetting.key().replaceAll("\\.", "_") + "]", buildSetting.value());
        }
    }

    StructureDataType toStructure(DataTypeManager dtm) {
        StructureDataType result = new StructureDataType(GoConstants.GOLANG_CATEGORYPATH, "GoBuildInfo", 0, dtm);
        result.add((DataType)new ArrayDataType(StructConverter.ASCII, 14, -1, dtm), "magic", "\\xff Go buildinf:");
        result.add(StructConverter.BYTE, "ptrSize", null);
        result.add(StructConverter.BYTE, "flags", null);
        return result;
    }

    public String toString() {
        return String.format("GoBuildInfo [pointerSize=%s, endian=%s, version=%s, path=%s]", this.pointerSize, this.endian, this.version, this.path);
    }

    private static GoBuildInfo readStringInfo(BinaryReader reader, boolean inlineStr, Program program, int ptrSize) throws IOException {
        String moduleString;
        String versionString;
        if (inlineStr) {
            reader.setPointerIndex(32);
            versionString = reader.readNext(GoBuildInfo::varlenString);
            byte[] moduleStringBytes = reader.readNext(GoBuildInfo::varlenBytes);
            moduleString = GoBuildInfo.extractModuleString(moduleStringBytes);
        } else {
            reader.setPointerIndex(16);
            long versionStrOffset = reader.readNextUnsignedValue(ptrSize);
            long moduleStrOffset = reader.readNextUnsignedValue(ptrSize);
            MemoryByteProvider memBP = new MemoryByteProvider(program.getMemory(), program.getImageBase().getAddressSpace());
            BinaryReader fullReader = new BinaryReader(memBP, reader.isLittleEndian());
            fullReader.setPointerIndex(versionStrOffset);
            versionString = GoBuildInfo.readGoString(fullReader, ptrSize);
            fullReader.setPointerIndex(moduleStrOffset);
            byte[] moduleStrBytes = GoBuildInfo.readRawGoString(fullReader, ptrSize);
            moduleString = GoBuildInfo.extractModuleString(moduleStrBytes);
        }
        return GoBuildInfo.parseBuildInfo(ptrSize, reader.isBigEndian() ? Endian.BIG : Endian.LITTLE, versionString, moduleString);
    }

    private static GoBuildInfo parseBuildInfo(int pointerSize, Endian endian, String versionString, String moduleString) throws IOException {
        String path = null;
        GoModuleInfo module = null;
        ArrayList<GoModuleInfo> deps = new ArrayList<GoModuleInfo>();
        ArrayList<GoBuildSettings> buildSettings = new ArrayList<GoBuildSettings>();
        String[] lines = moduleString.split("\n");
        block12: for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            String replaceInfo;
            String line = lines[lineNum];
            String string = replaceInfo = lineNum + 1 < lines.length && lines[lineNum + 1].startsWith("=>\t") ? lines[++lineNum].substring(3) : null;
            if (line.isBlank()) continue;
            String[] lineParts = line.split("\t", 2);
            switch (lineParts[0]) {
                case "path": {
                    path = lineParts[1];
                    continue block12;
                }
                case "mod": {
                    GoModuleInfo replace = replaceInfo != null ? GoModuleInfo.fromString(replaceInfo, null) : null;
                    module = GoModuleInfo.fromString(lineParts[1], replace);
                    continue block12;
                }
                case "dep": {
                    GoModuleInfo dep = GoModuleInfo.fromString(lineParts[1], null);
                    deps.add(dep);
                    continue block12;
                }
                case "build": {
                    GoBuildSettings build = GoBuildSettings.fromString(lineParts[1]);
                    buildSettings.add(build);
                }
            }
        }
        if (versionString.startsWith("go")) {
            versionString = versionString.substring(2);
        }
        return new GoBuildInfo(pointerSize, endian, versionString, path, module, deps, buildSettings);
    }

    private static String extractModuleString(byte[] bytes) throws IOException {
        int sentLen = INFOSTART_SENTINEL.length;
        if (bytes.length < sentLen * 2) {
            return "";
        }
        int sentEndStart = bytes.length - sentLen;
        if (!Arrays.equals(INFOSTART_SENTINEL, 0, sentLen, bytes, 0, sentLen) || !Arrays.equals(INFOEND_SENTINEL, 0, sentLen, bytes, sentEndStart, bytes.length)) {
            throw new IOException("bad sentinel");
        }
        return new String(bytes, sentLen, bytes.length - sentLen * 2, StandardCharsets.UTF_8);
    }

    private static String varlenString(BinaryReader reader) throws IOException {
        byte[] bytes = GoBuildInfo.varlenBytes(reader);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static byte[] varlenBytes(BinaryReader reader) throws IOException {
        int strLen = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        byte[] bytes = reader.readNextByteArray(strLen);
        return bytes;
    }

    private static String readGoString(BinaryReader reader, int ptrSize) throws IOException {
        byte[] bytes = GoBuildInfo.readRawGoString(reader, ptrSize);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static byte[] readRawGoString(BinaryReader reader, int ptrSize) throws IOException {
        long dataAddr = reader.readNextUnsignedValue(ptrSize);
        long dataLen = reader.readNextUnsignedValue(ptrSize);
        if (dataAddr == 0L || dataLen == 0L) {
            return new byte[0];
        }
        byte[] bytes = reader.readByteArray(dataAddr, (int)dataLen);
        return bytes;
    }
}

