/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeaderType;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.StringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.function.BiConsumer;

public class ElfProgramHeader
implements StructConverter,
Comparable<ElfProgramHeader>,
MemoryLoadable {
    protected ElfHeader header;
    private int p_type;
    private int p_flags;
    private long p_offset;
    private long p_vaddr;
    private long p_paddr;
    private long p_filesz;
    private long p_memsz;
    private long p_align;
    private BinaryReader reader;

    public ElfProgramHeader(BinaryReader reader, ElfHeader header) throws IOException {
        this.header = header;
        this.reader = reader;
        if (header.is32Bit()) {
            this.p_type = reader.readNextInt();
            this.p_offset = Integer.toUnsignedLong(reader.readNextInt());
            this.p_vaddr = Integer.toUnsignedLong(reader.readNextInt());
            this.p_paddr = Integer.toUnsignedLong(reader.readNextInt());
            this.p_filesz = Integer.toUnsignedLong(reader.readNextInt());
            this.p_memsz = Integer.toUnsignedLong(reader.readNextInt());
            this.p_flags = reader.readNextInt();
            this.p_align = Integer.toUnsignedLong(reader.readNextInt());
        } else if (header.is64Bit()) {
            this.p_type = reader.readNextInt();
            this.p_flags = reader.readNextInt();
            this.p_offset = reader.readNextLong();
            this.p_vaddr = reader.readNextLong();
            this.p_paddr = reader.readNextLong();
            this.p_filesz = reader.readNextLong();
            this.p_memsz = reader.readNextLong();
            this.p_align = reader.readNextLong();
        }
        if (this.p_memsz > this.p_filesz) {
            // empty if block
        }
    }

    public ElfProgramHeader(ElfHeader header, int type) {
        this.header = header;
        this.p_type = type;
        this.p_flags = 7;
        this.p_align = 4096L;
        this.p_paddr = -1L;
        this.p_vaddr = -1L;
    }

    public ElfHeader getElfHeader() {
        return this.header;
    }

    public String getTypeAsString() {
        ElfProgramHeaderType programHeaderType = this.header.getProgramHeaderType(this.p_type);
        if (programHeaderType != null) {
            return programHeaderType.name;
        }
        return "PT_0x" + StringUtilities.pad((String)Integer.toHexString(this.p_type), (char)'0', (int)8);
    }

    public String toString() {
        return this.getTypeAsString();
    }

    public String getDescription() {
        String description;
        ElfProgramHeaderType programHeaderType = this.header.getProgramHeaderType(this.p_type);
        if (programHeaderType != null && (description = programHeaderType.description) != null && description.length() != 0) {
            return programHeaderType.description;
        }
        return null;
    }

    public String getComment() {
        String description = this.getDescription();
        if (description != null) {
            return this.getTypeAsString() + " - " + description;
        }
        return this.getTypeAsString();
    }

    public long getAlign() {
        return this.p_align;
    }

    public long getFileSize() {
        return this.p_filesz;
    }

    public int getFlags() {
        return this.p_flags;
    }

    public boolean isRead() {
        return this.header.getLoadAdapter().isSegmentReadable(this);
    }

    public boolean isWrite() {
        return this.header.getLoadAdapter().isSegmentWritable(this);
    }

    public boolean isExecute() {
        return this.header.getLoadAdapter().isSegmentExecutable(this);
    }

    public long getMemorySize() {
        return this.p_memsz;
    }

    public long getAdjustedMemorySize() {
        return this.header.getLoadAdapter().getAdjustedMemorySize(this);
    }

    public long getAdjustedLoadSize() {
        return this.header.getLoadAdapter().getAdjustedLoadSize(this);
    }

    @Override
    public boolean hasFilteredLoadInputStream(ElfLoadHelper elfLoadHelper, Address start) {
        return this.header.getLoadAdapter().hasFilteredLoadInputStream(elfLoadHelper, this, start);
    }

    @Override
    public InputStream getFilteredLoadInputStream(ElfLoadHelper elfLoadHelper, Address start, long dataLength, BiConsumer<String, Throwable> errorConsumer) throws IOException {
        return this.header.getLoadAdapter().getFilteredLoadInputStream(elfLoadHelper, this, start, dataLength, this.getRawInputStream());
    }

    @Override
    public InputStream getRawInputStream() throws IOException {
        return this.getRawByteProvider().getInputStream(0L);
    }

    private ByteProvider getRawByteProvider() {
        if (this.reader == null) {
            throw new UnsupportedOperationException("This ElfProgramHeader does not have a reader");
        }
        if (this.p_filesz <= 0L) {
            return ByteProvider.EMPTY_BYTEPROVIDER;
        }
        return new ByteProviderWrapper(this.reader.getByteProvider(), this.p_offset, this.p_filesz);
    }

    public BinaryReader getReader() {
        return this.reader;
    }

    public long getOffset() {
        return this.p_offset;
    }

    public boolean isInvalidOffset() {
        return this.p_offset < 0L || this.header.is32Bit() && this.p_offset == 0xFFFFFFFFL;
    }

    public long getOffset(long virtualAddress) {
        if (this.p_type != 1 || this.p_filesz == 0L || this.p_memsz == 0L) {
            throw new UnsupportedOperationException("virtualAddress not loaded by this segment");
        }
        if (this.getMemorySize() != this.getAdjustedMemorySize()) {
            throw new UnsupportedOperationException("unsupported use of filtered load segment");
        }
        long addressableUnitSize = this.p_filesz / this.getAdjustedLoadSize();
        return addressableUnitSize * (virtualAddress - this.getVirtualAddress()) + this.p_offset;
    }

    void setOffset(long offset) {
        this.p_offset = offset;
    }

    public long getPhysicalAddress() {
        return this.header.adjustAddressForPrelink(this.p_paddr);
    }

    public int getType() {
        return this.p_type;
    }

    public long getVirtualAddress() {
        return this.header.adjustAddressForPrelink(this.p_vaddr);
    }

    @Override
    public DataType toDataType() {
        String dtName = this.header.is32Bit() ? "Elf32_Phdr" : "Elf64_Phdr";
        StructureDataType struct = new StructureDataType(new CategoryPath("/ELF"), dtName, 0);
        if (this.header.is32Bit()) {
            struct.add(this.getTypeDataType(), "p_type", null);
            struct.add(DWORD, "p_offset", null);
            struct.add(DWORD, "p_vaddr", null);
            struct.add(DWORD, "p_paddr", null);
            struct.add(DWORD, "p_filesz", null);
            struct.add(DWORD, "p_memsz", null);
            struct.add(DWORD, "p_flags", null);
            struct.add(DWORD, "p_align", null);
        } else {
            struct.add(this.getTypeDataType(), "p_type", null);
            struct.add(DWORD, "p_flags", null);
            struct.add(QWORD, "p_offset", null);
            struct.add(QWORD, "p_vaddr", null);
            struct.add(QWORD, "p_paddr", null);
            struct.add(QWORD, "p_filesz", null);
            struct.add(QWORD, "p_memsz", null);
            struct.add(QWORD, "p_align", null);
        }
        return struct;
    }

    private DataType getTypeDataType() {
        HashMap<Integer, ElfProgramHeaderType> programHeaderTypeMap = this.header.getProgramHeaderTypeMap();
        if (programHeaderTypeMap == null) {
            return DWordDataType.dataType;
        }
        Object dtName = "Elf_ProgramHeaderType";
        String typeSuffix = this.header.getTypeSuffix();
        if (typeSuffix != null) {
            dtName = (String)dtName + typeSuffix;
        }
        EnumDataType typeEnum = new EnumDataType(new CategoryPath("/ELF"), (String)dtName, 4);
        for (ElfProgramHeaderType type : programHeaderTypeMap.values()) {
            typeEnum.add(type.name, (long)type.value);
        }
        return typeEnum;
    }

    @Override
    public int compareTo(ElfProgramHeader that) {
        if (this.p_type == 1) {
            if (this.p_vaddr < that.p_vaddr) {
                if (this.p_vaddr == -1L) {
                    return 1;
                }
                return -1;
            }
            if (this.p_vaddr > that.p_vaddr) {
                if (that.p_vaddr == -1L) {
                    return -1;
                }
                return 1;
            }
        }
        return 0;
    }

    public int hashCode() {
        return (int)(31L * this.p_offset + (this.p_offset >>> 32));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElfProgramHeader)) {
            return false;
        }
        ElfProgramHeader other = (ElfProgramHeader)obj;
        return this.reader == other.reader && this.p_type == other.p_type && this.p_flags == other.p_flags && this.p_offset == other.p_offset && this.p_vaddr == other.p_vaddr && this.p_paddr == other.p_paddr && this.p_filesz == other.p_filesz && this.p_memsz == other.p_memsz && this.p_align == other.p_align;
    }
}

