/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFNumericAttribute;

public class DWARFSourceInfo {
    private final String filename;
    private final int lineNum;

    public static DWARFSourceInfo create(DIEAggregate diea) {
        String file = null;
        for (DIEAggregate currentDIEA = diea; currentDIEA != null && (file = currentDIEA.getSourceFile()) == null; currentDIEA = currentDIEA.getParent()) {
        }
        if (file == null) {
            return null;
        }
        DWARFNumericAttribute declLineAttr = diea.findAttributeInChildren(59, 5, DWARFNumericAttribute.class);
        if (declLineAttr == null) {
            return null;
        }
        int lineNum = (int)declLineAttr.getUnsignedValue();
        return new DWARFSourceInfo(file, lineNum);
    }

    public static DWARFSourceInfo getSourceInfoWithFallbackToParent(DIEAggregate diea) {
        DIEAggregate declParent;
        DWARFSourceInfo dsi = DWARFSourceInfo.create(diea);
        if (dsi == null && (declParent = diea.getDeclParent()) != null) {
            dsi = DWARFSourceInfo.create(declParent);
        }
        return dsi;
    }

    public static String getDescriptionStr(DIEAggregate diea) {
        DWARFSourceInfo sourceInfo = DWARFSourceInfo.create(diea);
        return sourceInfo != null ? sourceInfo.getDescriptionStr() : null;
    }

    private DWARFSourceInfo(String filename, int lineNum) {
        this.filename = filename;
        this.lineNum = lineNum;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDescriptionStr() {
        return this.filename + ":" + this.lineNum;
    }

    public String getDescriptionStr2() {
        return String.format("File: %s Line: %d", this.filename, this.lineNum);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + this.lineNum;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DWARFSourceInfo)) {
            return false;
        }
        DWARFSourceInfo other = (DWARFSourceInfo)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        return this.lineNum == other.lineNum;
    }

    public String toString() {
        return "DWARFSourceInfo [filename=" + this.filename + ", lineNum=" + this.lineNum + "]";
    }
}

