/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.DWARFAbbreviation;
import ghidra.app.util.bin.format.dwarf4.DWARFAttributeSpecification;
import ghidra.app.util.bin.format.dwarf4.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAttributeFactory;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf4.attribs.DWARFBooleanAttribute;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf4.encoding.DWARFTag;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DebugInfoEntry {
    private static final Set<Integer> ATTRIBUTES_TO_SKIP = Set.of(Integer.valueOf(1), Integer.valueOf(50));
    private final DWARFCompilationUnit compilationUnit;
    private final long offset;
    private final DWARFAbbreviation abbreviation;
    private final DWARFAttributeValue[] attributes;
    private long parentOffset = -1L;
    private List<DebugInfoEntry> children;

    public static DebugInfoEntry read(BinaryReader reader, DWARFCompilationUnit unit, DWARFAttributeFactory attributeFactory) throws IOException {
        long offset = reader.getPointerIndex();
        int abbreviationCode = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        if (abbreviationCode == 0) {
            return new DebugInfoEntry(unit, offset, null);
        }
        DWARFAbbreviation abbreviation = unit.getCodeToAbbreviationMap().get(abbreviationCode);
        if (abbreviation == null) {
            throw new IOException("Abbreviation code " + abbreviationCode + " not found in the abbreviation map for compunit " + unit);
        }
        DebugInfoEntry result = new DebugInfoEntry(unit, offset, abbreviation);
        DWARFAttributeSpecification[] attributeSpecs = result.abbreviation.getAttributes();
        for (int i = 0; i < attributeSpecs.length; ++i) {
            DWARFAttributeSpecification attributeSpec = attributeSpecs[i];
            result.attributes[i] = attributeFactory.read(reader, unit, attributeSpec.getAttributeForm());
            if (!ATTRIBUTES_TO_SKIP.contains(attributeSpec.getAttribute())) continue;
            result.attributes[i] = DWARFBooleanAttribute.TRUE;
        }
        return result;
    }

    public DebugInfoEntry(DWARFCompilationUnit unit, long offset, DWARFAbbreviation abbreviation) {
        this.compilationUnit = unit;
        this.offset = offset;
        this.abbreviation = abbreviation;
        this.attributes = abbreviation != null ? new DWARFAttributeValue[abbreviation.getAttributeCount()] : null;
    }

    public void addChild(DebugInfoEntry child) {
        if (this.children == null) {
            this.children = new ArrayList<DebugInfoEntry>(5);
        }
        this.children.add(child);
    }

    public List<DebugInfoEntry> getChildren() {
        return this.children != null ? this.children : Collections.EMPTY_LIST;
    }

    public List<DebugInfoEntry> getChildren(int childTag) {
        ArrayList<DebugInfoEntry> result = new ArrayList<DebugInfoEntry>();
        for (DebugInfoEntry child : this.getChildren()) {
            if (child.getTag() != childTag) continue;
            result.add(child);
        }
        return result;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setParent(DebugInfoEntry parent) {
        this.parentOffset = parent != null ? parent.getOffset() : -1L;
    }

    public DebugInfoEntry getParent() {
        return this.parentOffset != -1L ? this.compilationUnit.getProgram().getEntryAtByteOffsetUnchecked(this.parentOffset) : null;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getTag() {
        return this.abbreviation != null ? this.abbreviation.getTag() : 0;
    }

    public DWARFAttributeValue[] getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(int attribute) {
        if (this.abbreviation == null) {
            return false;
        }
        for (DWARFAttributeSpecification as : this.abbreviation.getAttributes()) {
            if (as.getAttribute() != attribute) continue;
            return true;
        }
        return false;
    }

    public DWARFAbbreviation getAbbreviation() {
        return this.abbreviation;
    }

    public boolean isTerminator() {
        return this.abbreviation == null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(" - Offset: 0x").append(Long.toHexString(this.offset)).append("\n");
        buffer.append("AbbreviationCode: 0x").append(Long.toHexString(this.abbreviation != null ? (long)this.abbreviation.getAbbreviationCode() : 0L));
        if (this.isTerminator()) {
            return buffer.toString();
        }
        buffer.append(" ").append(DWARFUtil.toString(DWARFTag.class, this.abbreviation.getTag())).append("\n");
        DWARFAttributeSpecification[] attributeSpecs = this.abbreviation.getAttributes();
        for (int i = 0; i < attributeSpecs.length; ++i) {
            DWARFAttributeSpecification attributeSpec = attributeSpecs[i];
            buffer.append("\tAttribute: ");
            buffer.append(DWARFUtil.toString(DWARFAttribute.class, attributeSpec.getAttribute()));
            buffer.append(" ");
            buffer.append(this.attributes[i]);
            buffer.append(" ");
            buffer.append(attributeSpec.getAttributeForm().toString());
            buffer.append("\n");
        }
        if (this.children != null && !this.children.isEmpty()) {
            buffer.append("\tChild count: ").append(this.children.size()).append("\n");
        }
        return buffer.toString();
    }

    public DWARFCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DebugInfoEntry)) {
            return false;
        }
        DebugInfoEntry other = (DebugInfoEntry)obj;
        return this.offset == other.offset;
    }
}

