/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select.reference;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.plugin.core.select.reference.SelectBackRefsAction;
import ghidra.app.plugin.core.select.reference.SelectForwardRefsAction;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Select References", description="This plugin selects references to or from the current location or selection.")
public class SelectRefsPlugin
extends Plugin {
    private DockingAction forwardAction;
    private DockingAction backwardAction;

    public SelectRefsPlugin(PluginTool tool) {
        super(tool);
        this.setupActions();
    }

    public void dispose() {
        this.tool.removeAction((DockingActionIf)this.forwardAction);
        this.tool.removeAction((DockingActionIf)this.backwardAction);
        this.forwardAction = null;
        this.backwardAction = null;
    }

    private void setupActions() {
        this.forwardAction = new SelectForwardRefsAction(this.tool, this.getName());
        this.backwardAction = new SelectBackRefsAction(this.tool, this.getName());
        this.tool.addAction((DockingActionIf)this.forwardAction);
        this.tool.addAction((DockingActionIf)this.backwardAction);
    }
}

