/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.processors;

import docking.DialogComponentProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.LcsSelectionListener;
import ghidra.plugin.importer.NewLanguagePanel;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import javax.swing.BorderFactory;

public class SetLanguageDialog
extends DialogComponentProvider {
    private NewLanguagePanel selectLangPanel;
    private PluginTool tool;
    private LanguageCompilerSpecPair currentLCSPair;
    private LanguageID dialogLanguageID;
    private CompilerSpecID dialogCompilerSpecID;
    LcsSelectionListener listener = e -> {
        LanguageID langID = null;
        CompilerSpecID compilerSpecID = null;
        if (e != null && e.selection != null) {
            langID = e.selection.languageID;
            compilerSpecID = e.selection.compilerSpecID;
        }
        if (this.currentLCSPair != null && langID != null && langID.equals((Object)this.currentLCSPair.getLanguageID())) {
            if (compilerSpecID != null && compilerSpecID.equals((Object)this.currentLCSPair.getCompilerSpecID())) {
                this.setStatusText("Please select a different Language or Compiler Spec.");
                this.setOkEnabled(false);
            } else {
                this.setStatusText(null);
                this.setOkEnabled(true);
            }
            return;
        }
        this.setStatusText(null);
        this.setOkEnabled(langID != null);
    };

    public SetLanguageDialog(PluginTool tool, ProgramArchitecture programArch, String title) {
        this(tool, programArch != null ? programArch.getLanguageCompilerSpecPair() : null, title);
    }

    public SetLanguageDialog(PluginTool tool, String languageId, String compilerSpecId, String title) {
        this(tool, SetLanguageDialog.getLanguageCompilerSpecPair(languageId, compilerSpecId), title);
    }

    public SetLanguageDialog(PluginTool tool, LanguageCompilerSpecPair lcsPair, String title) {
        super(title, true, true, true, false);
        this.currentLCSPair = lcsPair;
        this.tool = tool;
        this.selectLangPanel = new NewLanguagePanel();
        if (lcsPair != null) {
            this.selectLangPanel.setSelectedLcsPair(lcsPair);
        }
        this.selectLangPanel.addSelectionListener(this.listener);
        this.selectLangPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addWorkPanel(this.selectLangPanel);
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(false);
        this.setHelpLocation(new HelpLocation("LanguageProviderPlugin", "set language"));
        this.selectLangPanel.setShowRecommendedCheckbox(false);
        this.listener.valueChanged(null);
    }

    private static LanguageCompilerSpecPair getLanguageCompilerSpecPair(String languageIdStr, String compilerSpecIdStr) {
        if (languageIdStr == null) {
            return null;
        }
        LanguageService languageService = DefaultLanguageService.getLanguageService();
        try {
            LanguageID languageId = new LanguageID(languageIdStr);
            LanguageDescription descr = languageService.getLanguageDescription(languageId);
            CompilerSpecID compilerSpecId = new CompilerSpecID(compilerSpecIdStr);
            try {
                descr.getCompilerSpecDescriptionByID(compilerSpecId);
            }
            catch (CompilerSpecNotFoundException e) {
                Msg.warn(SetLanguageDialog.class, (Object)e.getMessage());
            }
            return new LanguageCompilerSpecPair(languageId, compilerSpecId);
        }
        catch (LanguageNotFoundException e) {
            Msg.warn(SetLanguageDialog.class, (Object)e.getMessage());
            return null;
        }
    }

    public LanguageID getLanguageDescriptionID() {
        this.tool.showDialog((DialogComponentProvider)this);
        return this.dialogLanguageID;
    }

    public CompilerSpecID getCompilerSpecDescriptionID() {
        return this.dialogCompilerSpecID;
    }

    protected void okCallback() {
        LanguageCompilerSpecPair selectedLcsPair = this.selectLangPanel.getSelectedLcsPair();
        if (selectedLcsPair == null) {
            this.dialogLanguageID = null;
            this.dialogCompilerSpecID = null;
        } else {
            this.dialogLanguageID = selectedLcsPair.languageID;
            this.dialogCompilerSpecID = selectedLcsPair.compilerSpecID;
        }
        this.close();
    }
}

