/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonProvider;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.JComboBox;

public class NextFunctionAction
extends DockingAction {
    private static final String FUNCTION_NAVIGATE_GROUP = "A9_FunctionNavigate";
    private static final Icon NEXT_FUNCTION_ICON = new GIcon("icon.plugin.functioncompare.function.next");

    public NextFunctionAction(MultiFunctionComparisonProvider provider) {
        super("Compare Next Function", provider.getOwner());
        this.setKeyBindingData(new KeyBindingData('N', 192));
        this.setDescription("Compare the next function for the side with focus.");
        this.setPopupMenuData(new MenuData(new String[]{"Compare The Next Function"}, NEXT_FUNCTION_ICON, FUNCTION_NAVIGATE_GROUP));
        ToolBarData newToolBarData = new ToolBarData(NEXT_FUNCTION_ICON, FUNCTION_NAVIGATE_GROUP);
        this.setToolBarData(newToolBarData);
        HelpLocation helpLocation = new HelpLocation("FunctionComparison", "Navigate_Next");
        this.setHelpLocation(helpLocation);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context.getComponentProvider() instanceof MultiFunctionComparisonProvider)) {
            return false;
        }
        MultiFunctionComparisonProvider provider = (MultiFunctionComparisonProvider)context.getComponentProvider();
        FunctionComparisonPanel comp = provider.getComponent();
        if (!(comp instanceof MultiFunctionComparisonPanel)) {
            return false;
        }
        MultiFunctionComparisonPanel panel = (MultiFunctionComparisonPanel)comp;
        JComboBox<Function> focusedComponent = panel.getFocusedComponent();
        return focusedComponent.getSelectedIndex() < focusedComponent.getModel().getSize() - 1;
    }

    public void actionPerformed(ActionContext context) {
        ComponentProvider provider = context.getComponentProvider();
        MultiFunctionComparisonPanel panel = (MultiFunctionComparisonPanel)provider.getComponent();
        JComboBox<Function> focusedComponent = panel.getFocusedComponent();
        focusedComponent.setSelectedIndex(focusedComponent.getSelectedIndex() + 1);
    }
}

