/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datawindow;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GHtmlCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.filter.FilterListener;
import docking.widgets.filter.FilterTextField;
import docking.widgets.label.GLabel;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.datawindow.DataWindowPlugin;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import resources.Icons;

class FilterAction
extends ToggleDockingAction {
    private static final String ENTIRE_PROGRAM = "Entire Program";
    private static final String CURRENT_VIEW = "Current View";
    private static final String SELECTION = "Current Selection";
    private DataWindowPlugin plugin;
    private boolean filterEnabled = false;
    private boolean viewMode = false;
    private boolean selectionMode = false;
    private SortMapComparatorASC SortMapComparatorASCObj = new SortMapComparatorASC();
    private SortedMap<String, Boolean> typeEnabledMap = new TreeMap<String, Boolean>(this.SortMapComparatorASCObj);

    FilterAction(DataWindowPlugin plugin) {
        super("Filter Data Types", plugin.getName());
        this.plugin = plugin;
        this.setDescription("Filters table so only specified types are displayed");
        this.setEnabled(true);
        this.setToolBarData(new ToolBarData(Icons.CONFIGURE_FILTER_ICON));
        this.setSelected(false);
    }

    public void actionPerformed(ActionContext context) {
        FilterDialog dialog = new FilterDialog();
        dialog.setSelectionEnabled(this.plugin.getSelection() != null);
        dialog.updateButtonEnabledState();
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
    }

    synchronized void clearTypes() {
        this.typeEnabledMap.clear();
    }

    synchronized void addType(String type) {
        Boolean bool = !this.filterEnabled;
        this.typeEnabledMap.put(type, bool);
    }

    synchronized boolean typeEnabled(String type) {
        if (!this.filterEnabled) {
            return true;
        }
        Boolean bool = (Boolean)this.typeEnabledMap.get(type);
        return bool != null && bool != false;
    }

    synchronized ArrayList<String> getSelectedTypes() {
        ArrayList<String> list = new ArrayList<String>();
        for (String type : this.typeEnabledMap.keySet()) {
            Boolean lEnabled = (Boolean)this.typeEnabledMap.get(type);
            if (lEnabled == null || !((Boolean)this.typeEnabledMap.get(type)).booleanValue()) continue;
            list.add(type);
        }
        return list;
    }

    synchronized void selectTypes(ArrayList<String> list) {
        for (String element : list) {
            this.typeEnabledMap.put(element, Boolean.TRUE);
        }
    }

    boolean getViewMode() {
        return this.viewMode;
    }

    boolean getSelectionMode() {
        return this.selectionMode;
    }

    void setTypeEnabled(String type, boolean enabled) {
        this.typeEnabledMap.put(type, enabled);
    }

    void setFilterEnabled(boolean filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    void programClosed() {
        this.typeEnabledMap = new TreeMap<String, Boolean>();
        this.filterEnabled = false;
        this.viewMode = false;
        this.selectionMode = false;
        this.setEnabled(false);
        this.clearTypes();
    }

    void programOpened(Program program) {
        this.setEnabled(true);
    }

    private static class SortMapComparatorASC
    implements Comparator<String> {
        private SortMapComparatorASC() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 != null) {
                if (!o1.equalsIgnoreCase(o2)) {
                    return o1.compareToIgnoreCase(o2);
                }
                return o1.compareTo(o2);
            }
            return -1;
        }
    }

    private class FilterDialog
    extends DialogComponentProvider {
        private JPanel mainPanel;
        private List<JCheckBox> checkboxes;
        private JPanel checkboxPanel;
        private JRadioButton enableButton;
        private JRadioButton disableButton;
        private GhidraComboBox<String> limitComboBox;
        private JButton selectAllButton;
        private JButton selectNoneButton;
        private FilterTextField filterField;
        private List<String> filteredList;
        private SwingUpdateManager updateManager;
        private KeyListener listener;
        private ItemListener itemListener;
        private FilterListener filterListener;

        FilterDialog() {
            super("Set Data Type Filter");
            this.checkboxes = new ArrayList<JCheckBox>();
            this.filteredList = new ArrayList<String>();
            this.updateManager = new SwingUpdateManager(250, 1000, () -> this.updateCheckBoxListFilter());
            this.listener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 && e.getModifiers() == 0) {
                        e.consume();
                        FilterDialog.this.okCallback();
                    }
                }
            };
            this.itemListener = e -> {
                JCheckBox typeCheckBox = (JCheckBox)e.getItem();
                FilterAction.this.setTypeEnabled(typeCheckBox.getName(), typeCheckBox.isSelected());
            };
            this.filterListener = new FilterActionFilterListener();
            this.addWorkPanel(this.create());
            this.addOKButton();
            this.setHelpLocation(new HelpLocation(FilterAction.this.plugin.getName(), "Filter_Data_Types"));
            this.setPreferredSize(360, 730);
        }

        void selectTypes(ArrayList<String> list) {
            for (String type : list) {
                this.selectCheckBox(type);
            }
        }

        private void selectCheckBox(String typeName) {
            for (JCheckBox cb : this.checkboxes) {
                if (!cb.getText().equals(typeName)) continue;
                cb.setSelected(true);
                return;
            }
        }

        private JComponent create() {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            JPanel enablePanel = new JPanel(new FlowLayout(0));
            ButtonGroup group = new ButtonGroup();
            this.enableButton = new GRadioButton("Enabled", true);
            this.enableButton.addKeyListener(this.listener);
            enablePanel.add(this.enableButton);
            group.add(this.enableButton);
            this.disableButton = new GRadioButton("Disabled", false);
            this.disableButton.addKeyListener(this.listener);
            enablePanel.add(this.disableButton);
            group.add(this.disableButton);
            enablePanel.setBorder(BorderFactory.createTitledBorder("Filter Enable"));
            this.mainPanel.add(enablePanel);
            this.enableButton.addChangeListener(e -> {
                boolean lenabled = this.enableButton.isSelected();
                for (JCheckBox curCheckbox : this.checkboxes) {
                    curCheckbox.setEnabled(lenabled);
                }
                this.selectAllButton.setEnabled(FilterAction.this.isEnabled());
                this.selectNoneButton.setEnabled(FilterAction.this.isEnabled());
                this.limitComboBox.setEnabled(FilterAction.this.isEnabled());
                this.filterField.setEnabled(lenabled);
            });
            JPanel limitPanel = new JPanel(new FlowLayout(0));
            this.limitComboBox = new GhidraComboBox();
            this.limitComboBox.addKeyListener(this.listener);
            this.limitComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{FilterAction.ENTIRE_PROGRAM, FilterAction.CURRENT_VIEW, FilterAction.SELECTION}));
            limitPanel.add((Component)this.limitComboBox);
            limitPanel.setBorder(BorderFactory.createTitledBorder("Limit Data To"));
            this.mainPanel.add(limitPanel);
            JPanel typesPanel = new JPanel(new BorderLayout());
            JPanel typeButtonPanel = new JPanel(new GridLayout(1, 2, 5, 0));
            this.selectAllButton = new JButton("Select All");
            this.selectAllButton.setMnemonic('A');
            this.selectAllButton.addActionListener(evt -> {
                Iterator<JCheckBox> itr = this.checkboxes.iterator();
                while (itr.hasNext()) {
                    itr.next().setSelected(true);
                }
            });
            typeButtonPanel.add(this.selectAllButton);
            this.selectNoneButton = new JButton("Select None");
            this.selectNoneButton.setMnemonic('N');
            this.selectNoneButton.addActionListener(evt -> {
                Iterator<JCheckBox> itr = this.checkboxes.iterator();
                while (itr.hasNext()) {
                    itr.next().setSelected(false);
                }
            });
            typeButtonPanel.add(this.selectNoneButton);
            this.checkboxPanel = new JPanel();
            this.checkboxPanel.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
            this.checkboxPanel.setLayout(new BoxLayout(this.checkboxPanel, 1));
            this.buildCheckBoxList();
            JScrollPane scroller = new JScrollPane(this.checkboxPanel);
            scroller.setPreferredSize(new Dimension(this.checkboxPanel.getPreferredSize().width, 150));
            typesPanel.add((Component)scroller, "Center");
            typesPanel.setBorder(BorderFactory.createTitledBorder("Enabled Data Types"));
            typesPanel.add((Component)typeButtonPanel, "South");
            this.mainPanel.add(typesPanel);
            JPanel filterBorderPanel = new JPanel(new GridLayout(1, 2, 5, 0));
            filterBorderPanel.setBorder(BorderFactory.createTitledBorder("Filter Enabled Data Types List Above"));
            JPanel filterPanel = new JPanel(new BorderLayout());
            this.filterField = new FilterTextField((Component)this.checkboxPanel);
            filterPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            filterPanel.add((Component)new GLabel("Filter:"), "West");
            filterPanel.add((Component)this.filterField, "Center");
            this.filterField.addFilterListener(this.filterListener);
            filterBorderPanel.add((Component)filterPanel, "Center");
            this.mainPanel.add(filterBorderPanel);
            return this.mainPanel;
        }

        private void updateButtonEnabledState() {
            if (this.filteredTextExists()) {
                this.selectNoneButton.setEnabled(false);
                this.selectAllButton.setEnabled(false);
            } else {
                this.selectNoneButton.setEnabled(true);
                this.selectAllButton.setEnabled(true);
            }
        }

        private void buildCheckBoxList() {
            this.checkboxPanel.removeAll();
            this.checkboxes.clear();
            if (!this.filteredList.isEmpty()) {
                Iterator<String> itr = this.filteredList.iterator();
                String filteredText = this.getFilteredText();
                while (itr.hasNext()) {
                    String curType = itr.next();
                    Boolean lEnabled = (Boolean)FilterAction.this.typeEnabledMap.get(curType);
                    StringBuffer buildMetaCurTypeBuff = new StringBuffer(curType);
                    int firstIndex = StringUtils.indexOfIgnoreCase((CharSequence)curType, (CharSequence)filteredText, (int)0);
                    int lastIndex = firstIndex + filteredText.length();
                    buildMetaCurTypeBuff.insert(lastIndex, "</b>");
                    buildMetaCurTypeBuff.insert(firstIndex, "<b>");
                    buildMetaCurTypeBuff.insert(0, "<html>");
                    this.createCheckBox(buildMetaCurTypeBuff.toString(), curType, lEnabled);
                }
            } else if (!this.filteredTextExists()) {
                for (String curType : FilterAction.this.typeEnabledMap.keySet()) {
                    Boolean lEnabled = (Boolean)FilterAction.this.typeEnabledMap.get(curType);
                    this.createCheckBox(curType, curType, lEnabled);
                }
            }
            this.repaint();
        }

        private String getFilteredText() {
            if (this.filterField != null) {
                return this.filterField.getText().trim();
            }
            return null;
        }

        private boolean filteredTextExists() {
            return this.getFilteredText() != null && this.getFilteredText().length() > 0;
        }

        private void repaint() {
            this.checkboxPanel.invalidate();
            this.mainPanel.validate();
            this.mainPanel.repaint();
        }

        private void createCheckBox(String curTypeHtml, String curType, Boolean lEnabled) {
            GHtmlCheckBox newCheckbox = new GHtmlCheckBox(curTypeHtml, lEnabled.booleanValue());
            newCheckbox.setName(curType);
            newCheckbox.addKeyListener(this.listener);
            newCheckbox.addItemListener(this.itemListener);
            DockingUtils.setTransparent((JComponent)newCheckbox);
            this.checkboxes.add((JCheckBox)newCheckbox);
            this.checkboxPanel.add((Component)newCheckbox);
        }

        private void updateCheckBoxListFilter() {
            ArrayList<String> checkboxNameList = new ArrayList<String>();
            if (this.filteredTextExists()) {
                String filteredText = this.getFilteredText();
                Set<Map.Entry<String, Boolean>> entrySet = FilterAction.this.typeEnabledMap.entrySet();
                for (Map.Entry<String, Boolean> entry : entrySet) {
                    String checkboxName = entry.getKey();
                    if (!StringUtils.containsIgnoreCase((CharSequence)checkboxName, (CharSequence)filteredText)) continue;
                    checkboxNameList.add(checkboxName);
                }
            }
            this.filteredList = checkboxNameList;
            this.buildCheckBoxList();
        }

        public void okCallback() {
            FilterAction.this.filterEnabled = this.enableButton.isSelected();
            FilterAction.this.viewMode = this.limitComboBox.getSelectedItem() == FilterAction.CURRENT_VIEW;
            FilterAction.this.selectionMode = this.limitComboBox.getSelectedItem() == FilterAction.SELECTION;
            this.close();
            FilterAction.this.setSelected(FilterAction.this.filterEnabled);
            FilterAction.this.plugin.reload();
        }

        public void cancelCallback() {
            this.okCallback();
        }

        private void clearTypes() {
            this.checkboxes.clear();
            this.checkboxPanel.removeAll();
            this.mainPanel.validate();
        }

        public void setSelectionEnabled(boolean enableSelection) {
            int modelSize = this.limitComboBox.getModel().getSize();
            if (enableSelection) {
                if (modelSize != 3) {
                    this.limitComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{FilterAction.ENTIRE_PROGRAM, FilterAction.CURRENT_VIEW, FilterAction.SELECTION}));
                }
            } else if (modelSize != 2) {
                this.limitComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{FilterAction.ENTIRE_PROGRAM, FilterAction.CURRENT_VIEW}));
            }
        }

        private class FilterActionFilterListener
        implements FilterListener {
            private FilterActionFilterListener() {
            }

            public void filterChanged(String text) {
                FilterDialog.this.updateButtonEnabledState();
                FilterDialog.this.updateManager.updateLater();
            }
        }
    }
}

