/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.editor;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.OptionDialog;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.compositeeditor.EditorListener;
import ghidra.app.plugin.core.compositeeditor.EditorProvider;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.editor.EnumEditorPanel;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypeManagerChangeListenerAdapter;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.DuplicateNameException;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang3.StringUtils;
import util.CollectionUtils;

public class EnumEditorProvider
extends ComponentProviderAdapter
implements ChangeListener,
EditorProvider {
    static final Icon EDITOR_ICON = new GIcon("icon.plugin.enum.editor.provider");
    private static final Icon APPLY_ICON = new GIcon("icon.plugin.enum.editor.apply");
    private static final Icon ADD_ICON = new GIcon("icon.plugin.enum.editor.add");
    private static final Icon DELETE_ICON = new GIcon("icon.plugin.enum.editor.delete");
    private static final String HELP_TOPIC = "DataTypeEditors";
    private static final int CANCEL = 0;
    private static final int SAVE = 1;
    private static final int NO_SAVE = 2;
    private static final int ERROR = 3;
    private DataTypeManagerPlugin plugin;
    private EnumEditorPanel editorPanel;
    private WeakSet<EditorListener> listeners;
    private MyDataTypeManagerChangeListener catListener;
    private DockingAction addAction;
    private DockingAction deleteAction;
    private DockingAction applyAction;
    private DataTypeManager dataTypeManager;
    private String originalEnumName;
    private CategoryPath originalCategoryPath;
    private Enum originalEnum;
    private long originalEnumID = -1L;
    private ToggleDockingAction hexDisplayAction;

    public EnumEditorProvider(DataTypeManagerPlugin plugin, Enum enumDT) {
        super(plugin.getTool(), "Enum Editor", plugin.getName());
        this.plugin = plugin;
        DataTypeManager enumDTM = enumDT.getDataTypeManager();
        if (enumDTM == null) {
            throw new IllegalArgumentException("Datatype " + enumDT.getName() + " doesn't have a data type manager specified.");
        }
        CategoryPath categoryPath = enumDT.getCategoryPath();
        Category category = enumDTM.getCategory(categoryPath);
        if (category == null) {
            throw new IllegalArgumentException("Datatype " + enumDT.getName() + " doesn't have a category specified.");
        }
        this.originalCategoryPath = categoryPath;
        this.originalEnum = enumDT;
        this.originalEnumName = enumDT.getDisplayName();
        this.dataTypeManager = enumDTM;
        this.setIcon(EDITOR_ICON);
        this.setHelpLocation(new HelpLocation(HELP_TOPIC, "EnumEditor"));
        this.catListener = new MyDataTypeManagerChangeListener();
        this.dataTypeManager.addDataTypeManagerListener((DataTypeManagerChangeListener)this.catListener);
        if (category.getDataType(this.originalEnumName) != null) {
            this.originalEnumID = this.dataTypeManager.getID((DataType)enumDT);
        }
        this.editorPanel = new EnumEditorPanel((EnumDataType)enumDT.copy(this.dataTypeManager), this);
        this.updateTitle((DataType)enumDT);
        this.tool.addComponentProvider((ComponentProvider)this, true);
        this.createActions();
        this.listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
        this.editorPanel.getTable().getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.setActionsEnabled();
        });
    }

    public String getWindowSubMenuName() {
        return this.getName();
    }

    public void closeComponent() {
        int result = this.saveChangesForCloseEvent(true);
        if (result == 1 || result == 2) {
            this.dispose();
        }
    }

    public JComponent getComponent() {
        return this.editorPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ActionContext((ComponentProvider)this, (Component)this.editorPanel.getTable());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.applyAction == null) {
            return;
        }
        this.applyAction.setEnabled(this.hasChanges());
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public boolean checkForSave(boolean allowCancel) {
        int result = this.saveChangesForCloseEvent(allowCancel);
        return result != 0 && result != 3 || !allowCancel;
    }

    @Override
    public void dispose() {
        this.tool.showComponentProvider((ComponentProvider)this, false);
        this.tool.removeComponentProvider((ComponentProvider)this);
        this.editorPanel.dispose();
        for (EditorListener el : this.listeners) {
            el.closed(this);
        }
        this.dataTypeManager.removeDataTypeManagerListener((DataTypeManagerChangeListener)this.catListener);
    }

    @Override
    public ComponentProvider getComponentProvider() {
        return this;
    }

    @Override
    public DataTypePath getDtPath() {
        return new DataTypePath(this.originalCategoryPath, this.originalEnumName);
    }

    @Override
    public boolean isEditing(DataTypePath dtPath) {
        return this.getDtPath().equals((Object)dtPath);
    }

    @Override
    public boolean needsSave() {
        return this.editorPanel.needsSave();
    }

    @Override
    public void domainObjectRestored(DataTypeManagerDomainObject domainObject) {
        if (this.originalEnumID == -1L) {
            return;
        }
        Enum enuum = (Enum)this.dataTypeManager.getDataType(this.originalEnumID);
        if (enuum != null) {
            EnumDataType dt = (EnumDataType)enuum.copy(this.dataTypeManager);
            this.originalEnumName = dt.getDisplayName();
            this.updateTitle((DataType)dt);
            Category category = this.dataTypeManager.getCategory(enuum.getCategoryPath());
            this.originalCategoryPath = category.getCategoryPath();
            this.editorPanel.domainObjectRestored(domainObject, dt);
        }
        this.tool.setStatusInfo("");
    }

    public boolean isTransient() {
        return true;
    }

    @Override
    public void show() {
        this.tool.showComponentProvider((ComponentProvider)this, true);
    }

    void setStatusMessage(String msg) {
        this.tool.setStatusInfo(msg);
    }

    String getCategoryText() {
        return this.dataTypeManager.getName() + this.originalCategoryPath;
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    private void updateTitle(DataType dataType) {
        this.setTitle(this.getName() + " - " + this.getProviderSubTitle(dataType));
        this.setTabText(dataType.getName());
    }

    private String getProviderSubTitle(DataType dataType) {
        String dtmName;
        DataTypeManager dtm = this.dataTypeManager;
        if (dtm == null) {
            return dataType.getDisplayName();
        }
        if (dtm instanceof ProgramBasedDataTypeManager) {
            ProgramBasedDataTypeManager programDtm = (ProgramBasedDataTypeManager)dtm;
            dtmName = programDtm.getProgram().getDomainFile().getName();
        } else {
            dtmName = dtm.getName();
        }
        return dataType.getDisplayName() + " (" + dtmName + ")";
    }

    private void createActions() {
        this.hexDisplayAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Toggle Hex Mode", this.plugin.getName()).menuPath(new String[]{"Show Enum Values in Hex"})).description("Toggles Enum value column to show values in hex or decimal")).keyBinding("Shift-H")).selected(true).onAction(c -> this.editorPanel.setHexDisplayMode(this.hexDisplayAction.isSelected()))).buildAndInstallLocal((ComponentProvider)this);
        this.addAction = new EnumPluginAction("Add Enum Value", e -> this.editorPanel.addEntry());
        this.addAction.setEnabled(true);
        String editGroup = "Edit";
        this.addAction.setPopupMenuData(new MenuData(new String[]{"Add"}, ADD_ICON, editGroup));
        this.addAction.setToolBarData(new ToolBarData(ADD_ICON, editGroup));
        this.addAction.setDescription("Add a new enum entry");
        this.deleteAction = new EnumPluginAction("Delete Enum Value", e -> this.editorPanel.deleteSelectedEntries());
        this.deleteAction.setEnabled(false);
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, DELETE_ICON, editGroup));
        this.deleteAction.setToolBarData(new ToolBarData(DELETE_ICON, editGroup));
        this.deleteAction.setDescription("Delete the selected enum entries");
        this.applyAction = new EnumPluginAction("Apply Enum Changes", e -> this.applyChanges());
        this.applyAction.setEnabled(false);
        String firstGroup = "ApplyChanges";
        this.applyAction.setToolBarData(new ToolBarData(APPLY_ICON, firstGroup));
        this.applyAction.setDescription("Apply changes to Enum");
        EnumPluginAction showEnumAction = new EnumPluginAction("Show In Data Type Manager", e -> this.showDataEnumInTree());
        showEnumAction.setEnabled(true);
        String thirdGroup = "FThirdGroup";
        showEnumAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.enum.editor.home"), thirdGroup));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.applyAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.addAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.deleteAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)showEnumAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyChanges() {
        EnumDataType editedEnum;
        this.setStatusMessage("");
        TableCellEditor editor = this.editorPanel.getTable().getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        if ((editedEnum = this.editorPanel.getEnum()).getCount() == 0) {
            this.setStatusMessage("Empty enum is not allowed");
            return false;
        }
        int txID = this.startTransaction();
        try {
            DataTypeManager dtm = editedEnum.getDataTypeManager();
            boolean userSaved = this.resolveEquateConflicts((Enum)editedEnum, dtm);
            if (!userSaved) {
                boolean bl = false;
                return bl;
            }
            Enum newEnuum = (Enum)this.dataTypeManager.resolve((DataType)this.originalEnum, null);
            this.applyName(newEnuum);
            this.applyDescription(newEnuum);
            newEnuum.replaceWith((DataType)editedEnum);
            this.originalEnum = newEnuum;
            this.editorPanel.setEnum((EnumDataType)newEnuum.copy(this.dataTypeManager));
            this.applyAction.setEnabled(this.hasChanges());
        }
        finally {
            this.endTransaction(txID);
        }
        return true;
    }

    private void showDataEnumInTree() {
        DataTypeManagerService dtmService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        dtmService.setDataTypeSelected((DataType)this.originalEnum);
    }

    private boolean resolveEquateConflicts(Enum editedEnum, DataTypeManager dtm) {
        Program program = this.plugin.getProgram();
        if (program == null) {
            return true;
        }
        EquateTable et = program.getEquateTable();
        HashSet<String> oldFieldConflicts = new HashSet<String>();
        HashSet<String> conflictingEquates = new HashSet<String>();
        for (Equate eq : CollectionUtils.asIterable((Iterator)et.getEquates())) {
            if (!eq.isEnumBased() || !this.originalEnum.getUniversalID().equals((Object)eq.getEnumUUID()) || editedEnum.getName(eq.getValue()) != null) continue;
            oldFieldConflicts.add(this.originalEnum.getName(eq.getValue()));
            conflictingEquates.add(eq.getName());
        }
        if (conflictingEquates.isEmpty()) {
            return true;
        }
        switch (this.showOptionDialog(editedEnum, oldFieldConflicts)) {
            case 1: {
                this.removeEquates(et, conflictingEquates);
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    private void removeEquates(EquateTable et, Set<String> equatesForDelete) {
        for (String name : equatesForDelete) {
            et.removeEquate(name);
        }
    }

    private int showOptionDialog(Enum editedEnoom, Set<String> oldNameFields) {
        StringBuilder msg = new StringBuilder("<html>If you save this Enum with the <font color=\"" + GThemeDefaults.Colors.Messages.ERROR.toHexString() + "\">new value(s)</font> listed below,<br> it will invalidate equates created with the old value(s).<br>");
        msg.append("<ul>");
        for (String field : oldNameFields) {
            Object newVal;
            try {
                newVal = "0x" + Long.toHexString(editedEnoom.getValue(field));
            }
            catch (NoSuchElementException e) {
                newVal = "Missing";
            }
            msg.append(String.format("<li>%s: 0x%s \u2192 <font color=\"" + GThemeDefaults.Colors.Messages.ERROR.toHexString() + "\">%s</font></li>", HTMLUtilities.escapeHTML((String)field), Long.toHexString(this.originalEnum.getValue(field)), newVal));
        }
        msg.append("</ul>");
        msg.append("Invalidated equates can be automatically removed now or<br>managed later from the <i><b>Equates Table</i></b> window.");
        msg.append("</html>");
        int choice = OptionDialog.showOptionDialog((Component)this.editorPanel, (String)"Equate Conflicts", (String)msg.toString(), (String)"Save and remove", (String)"Save", (int)0);
        return choice;
    }

    private void applyDescription(Enum newEnuum) {
        String editorDescription = this.editorPanel.getDescription();
        String originalDescription = newEnuum.getDescription();
        if (editorDescription != null) {
            if (!(editorDescription = editorDescription.trim()).equals(originalDescription)) {
                newEnuum.setDescription(editorDescription);
            }
        } else if (originalDescription != null) {
            newEnuum.setDescription(null);
        }
    }

    private void applyName(Enum newEnuum) {
        String editorName = this.editorPanel.getEnumName();
        if (this.originalEnumName.equals(editorName)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)editorName)) {
            Msg.showError((Object)this, (Component)this.editorPanel, (String)"Invalid Name", (Object)"Name cannot be empty.");
            return;
        }
        try {
            newEnuum.setName(editorName);
            this.originalEnumName = editorName;
            this.updateTitle((DataType)newEnuum);
        }
        catch (InvalidNameException e) {
            Msg.showError((Object)this, (Component)this.editorPanel, (String)"Invalid Name", (Object)"Name contains invalid characters.");
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)this, (Component)this.editorPanel, (String)"Duplicate Name", (Object)(editorName + " already exists."));
        }
    }

    private void setActionsEnabled() {
        this.deleteAction.setEnabled(false);
        int[] rows = this.editorPanel.getSelectedRows();
        if (rows.length > 0) {
            this.deleteAction.setEnabled(true);
        }
    }

    private int startTransaction() {
        return this.dataTypeManager.startTransaction("Edit Enum");
    }

    private void endTransaction(int transID) {
        this.dataTypeManager.endTransaction(transID, true);
    }

    private int saveChangesForCloseEvent(boolean allowCancel) {
        if (this.hasChanges()) {
            String question = "The Enum Editor is closing.\nSave the changes to " + this.editorPanel.getEnum().getDisplayName() + "?";
            String title = "Save Enum Editor Changes?";
            int response = allowCancel ? OptionDialog.showYesNoCancelDialog((Component)this.editorPanel, (String)title, (String)question) : OptionDialog.showYesNoDialog((Component)this.editorPanel, (String)title, (String)question);
            if (response == 1 && !this.applyChanges()) {
                return 3;
            }
            return response;
        }
        return 2;
    }

    public boolean hasChanges() {
        return this.editorPanel.needsSave();
    }

    private class MyDataTypeManagerChangeListener
    extends DataTypeManagerChangeListenerAdapter {
        private MyDataTypeManagerChangeListener() {
        }

        public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            if (!EnumEditorProvider.this.originalCategoryPath.equals((Object)oldPath)) {
                return;
            }
            Category newCategory = dtm.getCategory(newPath);
            if (newCategory == null) {
                return;
            }
            EnumEditorProvider.this.originalCategoryPath = newCategory.getCategoryPath();
            EnumEditorProvider.this.dataTypeManager = dtm;
            EnumEditorProvider.this.editorPanel.updateCategoryField(EnumEditorProvider.this.getCategoryText());
        }

        public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            if (!EnumEditorProvider.this.originalCategoryPath.equals((Object)oldPath)) {
                return;
            }
            Category newCategory = dtm.getCategory(newPath);
            if (newCategory == null) {
                return;
            }
            EnumEditorProvider.this.originalCategoryPath = newCategory.getCategoryPath();
            EnumEditorProvider.this.dataTypeManager = dtm;
            EnumEditorProvider.this.editorPanel.updateCategoryField(EnumEditorProvider.this.getCategoryText());
        }

        public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
        }

        public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
            if (!this.isMyCategory(path)) {
                return;
            }
            DataType currentDataType = this.getCurrentDataType();
            if (!this.isMyDataType(currentDataType, dtm, path)) {
                return;
            }
            if (!EnumEditorProvider.this.hasChanges()) {
                EnumEditorProvider.this.editorPanel.enumChanged((EnumDataType)((Enum)currentDataType).copy(dtm));
            }
            EnumEditorProvider.this.applyAction.setEnabled(EnumEditorProvider.this.hasChanges());
        }

        public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            if (!this.isMyCategory(oldPath)) {
                return;
            }
            DataType currentDataType = this.getCurrentDataType();
            if (!this.isMyDataType(currentDataType, dtm, newPath)) {
                return;
            }
            CategoryPath currentCategoryPath = currentDataType.getCategoryPath();
            Category category = dtm.getCategory(currentCategoryPath);
            EnumEditorProvider.this.originalCategoryPath = category.getCategoryPath();
            EnumEditorProvider.this.dataTypeManager = dtm;
            EnumEditorProvider.this.editorPanel.updateCategoryField(EnumEditorProvider.this.getCategoryText());
        }

        public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            if (!this.isMyCategory(oldPath)) {
                return;
            }
            DataType currentDataType = this.getCurrentDataType();
            if (!this.isMyDataType(currentDataType, dtm, newPath)) {
                return;
            }
            String newName = currentDataType.getDisplayName();
            String nameInTextField = EnumEditorProvider.this.editorPanel.getEnumName();
            if (EnumEditorProvider.this.originalEnumName.equals(nameInTextField)) {
                EnumEditorProvider.this.editorPanel.updateNameField(newName);
            }
            EnumEditorProvider.this.originalEnumName = newName;
            EnumEditorProvider.this.updateTitle(currentDataType);
        }

        public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
            if (!this.isMyCategory(path)) {
                return;
            }
            DataType currentDataType = this.getCurrentDataType();
            if (currentDataType != null) {
                return;
            }
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)EnumEditorProvider.this.editorPanel, (String)"Enum Data Type Removed", (Object)(path + " was removed from data type manager " + dtm.getName() + ".\nEdit session will be terminated."));
            EnumEditorProvider.this.dispose();
        }

        public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
            if (!this.isMyCategory(oldPath)) {
                return;
            }
            DataType currentDataType = this.getCurrentDataType();
            if (currentDataType != null) {
                return;
            }
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)EnumEditorProvider.this.editorPanel, (String)"Enum Data Type Replaced", (Object)(oldPath + " was replaced in data type manager " + dtm.getName() + ".\nEdit session will be terminated."));
            EnumEditorProvider.this.dispose();
        }

        private boolean isMyCategory(DataTypePath path) {
            CategoryPath parentPath = path.getCategoryPath();
            return parentPath.equals((Object)EnumEditorProvider.this.originalCategoryPath);
        }

        private DataType getCurrentDataType() {
            return EnumEditorProvider.this.dataTypeManager.getDataType(EnumEditorProvider.this.originalEnumID);
        }

        private boolean isMyDataType(DataType myDataType, DataTypeManager dtm, DataTypePath otherPath) {
            if (myDataType == null) {
                return false;
            }
            DataType dataType = dtm.getDataType(otherPath);
            if (dataType == null) {
                return true;
            }
            return myDataType == dataType;
        }
    }

    private class EnumPluginAction
    extends DockingAction {
        private final ActionListener listener;

        EnumPluginAction(String name, ActionListener listener) {
            super(name, EnumEditorProvider.this.plugin.getName());
            this.listener = listener;
            this.setHelpLocation(new HelpLocation(EnumEditorProvider.HELP_TOPIC, name));
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!this.isAllowedContext(context)) {
                return false;
            }
            return super.isEnabledForContext(context);
        }

        private boolean isAllowedContext(ActionContext context) {
            return EnumEditorProvider.this.editorPanel.getTableClass().isInstance(context.getContextObject());
        }

        public void actionPerformed(ActionContext context) {
            if (this.listener != null) {
                this.listener.actionPerformed(null);
            }
        }
    }
}

