/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.nav.Navigatable;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import javax.swing.Icon;

public class MarkAndSelectionAction
extends ToggleDockingAction {
    private Navigatable markedNavigatable;
    private ProgramLocation markedLocation;
    private Icon unarmedIcon;
    private Icon armedIcon;

    public MarkAndSelectionAction(String owner, String group, String subGroup) {
        super("Mark and Select", owner);
        this.buildIcons();
        MenuData menuData = new MenuData(new String[]{"Se&lect", "Mark Selection Start"});
        menuData.setMenuGroup(group);
        menuData.setMenuSubGroup(subGroup);
        this.setMenuBarData(menuData);
        this.setKeyBindingData(new KeyBindingData("m"));
        this.setToolBarData(new ToolBarData(this.unarmedIcon, "3_Toolbar_Navigation_Group", "Z"));
        this.setHelpLocation(new HelpLocation("Selection", "Mark_And_Select"));
        this.setSupportsDefaultToolContext(true);
        this.addToWindowWhen(NavigatableActionContext.class);
    }

    private void buildIcons() {
        this.unarmedIcon = new GIcon("icon.plugin.codebrowser.mark.and.select.unarmed");
        this.armedIcon = new GIcon("icon.plugin.codebrowser.mark.and.select.armed");
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (context instanceof NavigatableActionContext) {
            return ((NavigatableActionContext)context).getLocation() != null;
        }
        return false;
    }

    public final boolean isValidContext(ActionContext context) {
        return context instanceof NavigatableActionContext;
    }

    public void actionPerformed(ActionContext context) {
        if (context instanceof NavigatableActionContext) {
            this.actionPerformed((NavigatableActionContext)context);
        }
    }

    protected void actionPerformed(NavigatableActionContext context) {
        Navigatable navigatable = context.getNavigatable();
        if (this.isArmed(navigatable)) {
            this.createSelection(navigatable);
        } else {
            this.armSelection(navigatable);
        }
        this.updateAction();
    }

    private void updateAction() {
        Object menuName = "Mark Selection Start";
        Object description = "Mark current location for selection start";
        Icon icon = this.unarmedIcon;
        if (this.markedLocation != null) {
            Address address = this.markedLocation.getByteAddress();
            menuName = "Create Selection from " + address;
            description = "Create seletion from marked location: " + address;
            icon = this.armedIcon;
        }
        MenuData menuBarData = this.getMenuBarData();
        menuBarData.setMenuItemName((String)menuName);
        this.setDescription((String)description);
        this.getToolBarData().setIcon(icon);
    }

    private void armSelection(Navigatable navigatable) {
        this.markedNavigatable = navigatable;
        this.markedLocation = navigatable.getLocation();
        if (this.markedLocation == null) {
            this.markedNavigatable = null;
        }
    }

    private void createSelection(Navigatable navigatable) {
        ProgramLocation location = navigatable.getLocation();
        Address start = this.markedLocation.getByteAddress();
        Address end = location.getByteAddress();
        ProgramSelection selection = new ProgramSelection(start, end);
        navigatable.setSelection(selection);
        this.markedLocation = null;
        this.markedNavigatable = null;
    }

    private boolean isArmed(Navigatable navigatable) {
        if (this.markedNavigatable == null || this.markedLocation == null) {
            return false;
        }
        if (navigatable != this.markedNavigatable) {
            return false;
        }
        return this.markedLocation.getProgram() == navigatable.getProgram();
    }
}

