/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.label.DemanglerCmd;
import ghidra.app.plugin.core.analysis.MinGWPseudoRelocList;
import ghidra.app.util.bin.InvalidDataException;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.PeLoader;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class MinGWPseudoRelocationHandler {
    private static final int RP_VERSION_V1 = 0;
    private static final int RP_VERSION_V2 = 1;
    private static final int OLD_STYLE_ENTRY_SIZE = 8;
    private static final int NEW_STYLE_ENTRY_HEADER_SIZE = 12;
    static final String RELOC_TABLE_HEADER_STRUCT_NAME = "pseudoRelocListHeader";
    static final String V1_RELOC_ITEM_STRUCT_NAME = "pseudoRelocItemV1";
    static final String V2_RELOC_ITEM_STRUCT_NAME = "pseudoRelocItemV2";
    private Program program;
    private MinGWPseudoRelocList relocList;
    private int pointerSize;
    private DataType dwAddressDataType;

    MinGWPseudoRelocationHandler(Program program) throws InvalidDataException {
        this.program = program;
        this.relocList = new MinGWPseudoRelocList(program);
    }

    boolean listLabelsFound() {
        return this.relocList.listLabelsFound();
    }

    static boolean isSupportedProgram(Program program) {
        Language language = program.getLanguage();
        int size = language.getLanguageDescription().getSize();
        return "x86".equals(language.getProcessor().toString()) && (size == 32 || size == 64) && "windows".equals(program.getCompilerSpec().getCompilerSpecID().toString()) && PeLoader.CompilerOpinion.CompilerEnum.GCC.label.equals(program.getCompiler()) && MinGWPseudoRelocationHandler.getRDataBlock(program) != null;
    }

    private static MemoryBlock getRDataBlock(Program program) {
        Memory mem = program.getMemory();
        return mem.getBlock(".rdata");
    }

    private Symbol createPrimaryLabel(Address address, String name) {
        try {
            SymbolTable SymbolList = this.program.getSymbolTable();
            Symbol symbol = SymbolList.createLabel(address, name, null, SourceType.ANALYSIS);
            if (!symbol.isPrimary()) {
                symbol.setPrimary();
            }
            return symbol;
        }
        catch (InvalidInputException e) {
            throw new AssertException("unexpected", (Throwable)e);
        }
    }

    boolean processRelocations(MessageLog log, TaskMonitor monitor) throws CancelledException {
        boolean success;
        int version;
        Memory memory;
        long size;
        Address pdwListBeginAddr;
        block10: {
            Address pdwListEndAddr;
            pdwListBeginAddr = this.relocList.getListStartAddress();
            if (pdwListBeginAddr.equals((Object)(pdwListEndAddr = this.relocList.getListEndAddress()))) {
                return true;
            }
            this.pointerSize = this.program.getDefaultPointerSize();
            this.dwAddressDataType = new IBO32DataType((DataTypeManager)this.program.getDataTypeManager());
            size = pdwListEndAddr.subtract(pdwListBeginAddr);
            memory = this.program.getMemory();
            try {
                if (size >= 8L && memory.getLong(pdwListBeginAddr) != 0L) {
                    version = 0;
                    break block10;
                }
                if (size >= 12L) {
                    this.applyPseudoRelocHeader(pdwListBeginAddr, log);
                    version = memory.getInt(pdwListBeginAddr.add(8L));
                    pdwListBeginAddr = pdwListBeginAddr.add(12L);
                    size -= 12L;
                    break block10;
                }
                log.appendMsg("Unsupported MinGW relocation table at " + pdwListBeginAddr);
                return false;
            }
            catch (AddressOutOfBoundsException | MemoryAccessException e) {
                String msg = "MinGW relocation table processing failed at " + pdwListBeginAddr;
                log.appendMsg(msg);
                Msg.error((Object)this, (Object)msg, (Throwable)e);
                return false;
            }
        }
        switch (version) {
            case 0: {
                success = this.relocateV1(pdwListBeginAddr, (int)(size / 8L), log, monitor);
                break;
            }
            case 1: {
                success = this.relocateV2(pdwListBeginAddr, (int)(size / 12L), log, monitor);
                break;
            }
            default: {
                log.appendMsg("Unsupported MinGW relocation table (Version: " + version + ") at " + pdwListBeginAddr);
                return false;
            }
        }
        ExternalManager extMgr = this.program.getExternalManager();
        ReferenceManager refMgr = this.program.getReferenceManager();
        SymbolTable SymbolList = this.program.getSymbolTable();
        for (Symbol extSym : this.program.getSymbolTable().getExternalSymbols()) {
            Symbol s;
            List globalSymbols;
            monitor.checkCancelled();
            ExternalLocation extLoc = extMgr.getExternalLocation(extSym);
            if (extLoc.getOriginalImportedName() != null || refMgr.hasReferencesTo(extSym.getAddress()) || (globalSymbols = SymbolList.getGlobalSymbols(extSym.getName())).size() != 1 || !memory.isExternalBlockAddress((s = (Symbol)globalSymbols.get(0)).getAddress())) continue;
            extSym.delete();
        }
        return success;
    }

    private Address getDWAddress(MemBuffer buf) {
        return (Address)this.dwAddressDataType.getValue(buf, this.dwAddressDataType.getDefaultSettings(), -1);
    }

    private boolean relocateV2(Address pdwListBeginAddr, int entryCount, MessageLog log, TaskMonitor monitor) throws CancelledException {
        Address extBlockStart;
        Listing listing = this.program.getListing();
        Data d = listing.getDefinedDataAt(pdwListBeginAddr);
        if (d != null && (d.isArray() || d.isStructure())) {
            return false;
        }
        AddressSpace space = this.program.getAddressFactory().getDefaultAddressSpace();
        Memory memory = this.program.getMemory();
        ProgramBasedDataTypeManager dtm = this.program.getDataTypeManager();
        RelocationTable relocationTable = this.program.getRelocationTable();
        Address addr = pdwListBeginAddr;
        MemoryBufferImpl buf = new MemoryBufferImpl(memory, addr);
        HashSet<Address> uniqueIATAddressSet = new HashSet<Address>();
        for (int i = 0; i < entryCount; ++i) {
            monitor.checkCancelled();
            Address iatSymbolAddr = this.getDWAddress((MemBuffer)buf);
            if (iatSymbolAddr == null) {
                log.appendMsg("Failed to read Mingw pseudo-relocation symbol RVA at: " + addr);
                return false;
            }
            uniqueIATAddressSet.add(iatSymbolAddr);
            addr = addr.add(12L);
            buf.setPosition(addr);
        }
        int extBlockSize = uniqueIATAddressSet.size() * this.pointerSize;
        try {
            extBlockStart = this.allocateBlock("EXTERNAL", extBlockSize);
        }
        catch (Exception e) {
            String msg = "Failed to allocate EXTERNAL block for MinGW relocation processing";
            log.appendMsg(msg);
            Msg.error((Object)this, (Object)msg, (Throwable)e);
            return false;
        }
        ExternalIATSymbolMap extIATSymbolMap = new ExternalIATSymbolMap(extBlockStart);
        int applied = 0;
        int failed = 0;
        int unsupported = 0;
        addr = pdwListBeginAddr;
        buf.setPosition(addr);
        for (int i = 0; i < entryCount; ++i) {
            RelocationResult result;
            monitor.checkCancelled();
            Address iatSymbolAddr = this.getDWAddress((MemBuffer)buf);
            addr = addr.add(4L);
            buf.setPosition(addr);
            Address targetAddr = this.getDWAddress((MemBuffer)buf);
            if (targetAddr == null) {
                log.appendMsg("Failed to read Mingw pseudo-relocation target RVA at: " + addr);
                return false;
            }
            addr = addr.add(4L);
            buf.setPosition(addr);
            String symbolName = null;
            try {
                int bitLength = buf.getInt(0) & 0xFF;
                ExternalIATSymbol extSymbolEntry = extIATSymbolMap.allocateIATEntry(iatSymbolAddr, relocationTable);
                if (extSymbolEntry == null) {
                    throw new UnsupportedOperationException();
                }
                symbolName = extSymbolEntry.extLoc.getOriginalImportedName();
                if (symbolName == null) {
                    symbolName = extSymbolEntry.extLoc.getSymbol().getName();
                }
                long impValue = this.pointerSize == 8 ? memory.getLong(iatSymbolAddr) : Integer.toUnsignedLong(memory.getInt(iatSymbolAddr));
                Address pointerValue = space.getAddress(impValue);
                long qwOffset = pointerValue.subtract(iatSymbolAddr);
                long addend = 0L;
                result = new RelocationResult(Relocation.Status.APPLIED_OTHER, bitLength / 8);
                switch (bitLength) {
                    case 8: {
                        byte val8 = (byte)((long)memory.getByte(targetAddr) + qwOffset);
                        memory.setByte(targetAddr, val8);
                        ++applied;
                        break;
                    }
                    case 16: {
                        short val16 = (short)((long)memory.getShort(targetAddr) + qwOffset);
                        memory.setShort(targetAddr, val16);
                        ++applied;
                        break;
                    }
                    case 32: {
                        int val32 = memory.getInt(targetAddr);
                        if (this.pointerSize == 4) {
                            addend = val32 - (int)iatSymbolAddr.getOffset();
                        }
                        val32 = (int)((long)val32 + qwOffset);
                        memory.setInt(targetAddr, val32);
                        ++applied;
                        break;
                    }
                    case 64: {
                        long val64 = memory.getLong(targetAddr);
                        if (this.pointerSize == 8) {
                            addend = val64 - iatSymbolAddr.getOffset();
                        }
                        memory.setLong(targetAddr, val64 += qwOffset);
                        ++applied;
                        break;
                    }
                    default: {
                        result = RelocationResult.UNSUPPORTED;
                        ++unsupported;
                    }
                }
                if (addend != 0L) {
                    ElfRelocationHandler.warnExternalOffsetRelocation(this.program, targetAddr, pointerValue, symbolName, addend, null);
                    if (!memory.getBlock(targetAddr).isExecute()) {
                        ElfRelocationHandler.applyComponentOffsetPointer(this.program, targetAddr, addend);
                    }
                }
            }
            catch (MemoryAccessException | CodeUnitInsertionException | UnsupportedOperationException e) {
                this.markAsError(targetAddr, symbolName, e.getMessage(), log);
                result = RelocationResult.FAILURE;
                ++failed;
            }
            relocationTable.add(targetAddr, result.status(), 0, null, result.byteLength(), symbolName);
            addr = addr.add(4L);
            buf.setPosition(addr);
        }
        if (failed != 0 || unsupported != 0) {
            log.appendMsg("MinGW pseudo-relocations - applied:" + applied + " failed:" + failed + " unsupported:" + unsupported);
        }
        StructureDataType relocEntryStruct = new StructureDataType(V2_RELOC_ITEM_STRUCT_NAME, 0, (DataTypeManager)dtm);
        relocEntryStruct.setPackingEnabled(true);
        relocEntryStruct.add(this.dwAddressDataType, "sym", null);
        relocEntryStruct.add((DataType)DWordDataType.dataType, "target", null);
        relocEntryStruct.add((DataType)DWordDataType.dataType, "flags", null);
        ArrayDataType a = new ArrayDataType((DataType)relocEntryStruct, entryCount, -1, (DataTypeManager)dtm);
        try {
            DataUtilities.createData((Program)this.program, (Address)pdwListBeginAddr, (DataType)a, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
        }
        catch (CodeUnitInsertionException e) {
            log.appendMsg("Failed to markup Mingw pseudo-relocation List at: " + pdwListBeginAddr);
        }
        return true;
    }

    private void applyPseudoRelocHeader(Address relocHeaderAddr, MessageLog log) {
        StructureDataType relocHeaderStruct = new StructureDataType(RELOC_TABLE_HEADER_STRUCT_NAME, 0, (DataTypeManager)this.program.getDataTypeManager());
        relocHeaderStruct.setPackingEnabled(true);
        relocHeaderStruct.add((DataType)DWordDataType.dataType, "zero1", null);
        relocHeaderStruct.add((DataType)DWordDataType.dataType, "zero2", null);
        relocHeaderStruct.add((DataType)DWordDataType.dataType, "version", null);
        try {
            DataUtilities.createData((Program)this.program, (Address)relocHeaderAddr, (DataType)relocHeaderStruct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
        }
        catch (CodeUnitInsertionException e) {
            log.appendMsg("Failed to markup Mingw pseudo-relocation List header at: " + relocHeaderAddr);
        }
    }

    private void markAsError(Address relocationAddress, String symbolName, String msg, MessageLog log) {
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<noname>" : symbolName;
        log.appendMsg("MinGW Relocation Error: at " + relocationAddress + ", Symbol = " + symbolName + ": " + msg);
        BookmarkManager bookmarkManager = this.program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "MinGW Relocation", "MinGW Relocation Error: Symbol = " + symbolName + ": " + msg);
    }

    private void markAsError(Address relocationAddress, String msg, MessageLog log) {
        log.appendMsg("MinGW Relocation Error: at " + relocationAddress + ": " + msg);
        BookmarkManager bookmarkManager = this.program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "MinGW Relocation", "MinGW Relocation Error: " + msg);
    }

    private Address allocateBlock(String blockName, int extBlockSize) throws Exception {
        Memory memory = this.program.getMemory();
        AddressSpace space = this.program.getAddressFactory().getDefaultAddressSpace();
        long delta = 0x10000000L;
        Address startAddr = null;
        for (long offset = delta; offset < 0x100000000L; offset += delta) {
            Address addr = space.getAddress(offset);
            AddressIterator addresses = memory.getAddresses(addr, true);
            if (!addresses.hasNext()) {
                startAddr = addr;
                break;
            }
            Address nextAddr = addresses.next();
            if (nextAddr.getAddressSpace().equals(space) && nextAddr.subtract(addr) <= (long)extBlockSize) continue;
            startAddr = addr;
            break;
        }
        if (startAddr != null) {
            memory.createUninitializedBlock(blockName, startAddr, (long)extBlockSize, false);
            return startAddr;
        }
        throw new MemoryAccessException("Failed to allocate block: " + blockName);
    }

    private boolean relocateV1(Address pdwListPayloadAddr, int entryCount, MessageLog log, TaskMonitor monitor) throws CancelledException {
        Listing listing = this.program.getListing();
        Data d = listing.getDefinedDataAt(pdwListPayloadAddr);
        if (d != null && (d.isArray() || d.isStructure())) {
            return false;
        }
        Memory memory = this.program.getMemory();
        ProgramBasedDataTypeManager dtm = this.program.getDataTypeManager();
        RelocationTable relocationTable = this.program.getRelocationTable();
        Address addr = pdwListPayloadAddr;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(memory, pdwListPayloadAddr);
        RelocationResult appliedResult = new RelocationResult(Relocation.Status.APPLIED_OTHER, 4);
        int applied = 0;
        int failed = 0;
        for (int i = 0; i < entryCount; ++i) {
            monitor.checkCancelled();
            RelocationResult result = appliedResult;
            int dwOffset = 0;
            try {
                dwOffset = buf.getInt(0);
            }
            catch (MemoryAccessException e1) {
                log.appendMsg("Failed to read Mingw pseudo-relocation offset at: " + addr);
                return false;
            }
            addr = addr.add(4L);
            buf.setPosition(addr);
            Address targetAddr = this.getDWAddress((MemBuffer)buf);
            if (targetAddr == null) {
                log.appendMsg("Failed to read Mingw pseudo-relocation target RVA at: " + addr);
                return false;
            }
            try {
                int val32 = memory.getInt(targetAddr) + dwOffset;
                memory.setInt(targetAddr, val32);
                ++applied;
            }
            catch (Exception e) {
                this.markAsError(targetAddr, e.getMessage(), log);
                result = RelocationResult.FAILURE;
                ++failed;
            }
            relocationTable.add(targetAddr, result.status(), 0, null, result.byteLength(), null);
            addr = addr.add(4L);
            buf.setPosition(addr);
        }
        if (failed != 0) {
            log.appendMsg("MinGW pseudo-relocations - applied:" + applied + " failed:" + failed);
        }
        StructureDataType s = new StructureDataType(V1_RELOC_ITEM_STRUCT_NAME, 0, (DataTypeManager)dtm);
        s.setPackingEnabled(true);
        s.add((DataType)DWordDataType.dataType, "addend", null);
        s.add((DataType)DWordDataType.dataType, "target", null);
        ArrayDataType a = new ArrayDataType((DataType)s, entryCount, -1, (DataTypeManager)dtm);
        try {
            DataUtilities.createData((Program)this.program, (Address)pdwListPayloadAddr, (DataType)a, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)("Failed to markup Mingw pseudo-relocation List at: " + pdwListPayloadAddr));
        }
        return true;
    }

    private class ExternalIATSymbolMap
    extends HashMap<Address, ExternalIATSymbol> {
        private Address nextExtAddr;

        ExternalIATSymbolMap(Address extBlockStart) {
            this.nextExtAddr = extBlockStart;
        }

        ExternalIATSymbol allocateIATEntry(Address iatEntryAddr, RelocationTable relocationTable) throws MemoryAccessException, CodeUnitInsertionException {
            ExternalIATSymbol existingEntry = (ExternalIATSymbol)this.get(iatEntryAddr);
            if (existingEntry != null) {
                return existingEntry;
            }
            Reference ref = MinGWPseudoRelocationHandler.this.program.getReferenceManager().getPrimaryReferenceFrom(iatEntryAddr, 0);
            if (!ref.isExternalReference()) {
                return null;
            }
            Symbol extSym = MinGWPseudoRelocationHandler.this.program.getSymbolTable().getSymbol(ref);
            if (extSym == null) {
                return null;
            }
            ExternalLocation extLoc = MinGWPseudoRelocationHandler.this.program.getExternalManager().getExternalLocation(extSym);
            if (extLoc == null) {
                return null;
            }
            Listing listing = MinGWPseudoRelocationHandler.this.program.getListing();
            listing.clearCodeUnits(iatEntryAddr, iatEntryAddr, false);
            Memory memory = MinGWPseudoRelocationHandler.this.program.getMemory();
            if (MinGWPseudoRelocationHandler.this.pointerSize == 8) {
                memory.setLong(iatEntryAddr, this.nextExtAddr.getOffset());
            } else {
                memory.setInt(iatEntryAddr, (int)this.nextExtAddr.getOffset());
            }
            listing.createData(iatEntryAddr, (DataType)PointerDataType.dataType);
            relocationTable.add(iatEntryAddr, Relocation.Status.APPLIED_OTHER, 0, null, MinGWPseudoRelocationHandler.this.pointerSize, extSym.getName());
            try {
                if (extLoc.isFunction()) {
                    Function func = listing.createFunction(null, this.nextExtAddr, (AddressSetView)new AddressSet(this.nextExtAddr, this.nextExtAddr), SourceType.DEFAULT);
                    func.setThunkedFunction(extLoc.getFunction());
                } else {
                    listing.setComment(this.nextExtAddr, 3, "External Location: " + extSym.getName(true));
                    String name = extLoc.getOriginalImportedName();
                    boolean demangle = true;
                    if (name == null) {
                        name = extSym.getName();
                        demangle = false;
                    }
                    MinGWPseudoRelocationHandler.this.createPrimaryLabel(this.nextExtAddr, name);
                    if (demangle) {
                        DemanglerCmd cmd = new DemanglerCmd(this.nextExtAddr, name);
                        cmd.applyTo((DomainObject)MinGWPseudoRelocationHandler.this.program);
                    }
                }
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Failed to create EXTERNAL block symbol at " + this.nextExtAddr));
            }
            ExternalIATSymbol extIATSym = new ExternalIATSymbol(this.nextExtAddr, extLoc);
            this.put(iatEntryAddr, extIATSym);
            this.nextExtAddr = this.nextExtAddr.add((long)MinGWPseudoRelocationHandler.this.pointerSize);
            return extIATSym;
        }
    }

    private record ExternalIATSymbol(Address extAddr, ExternalLocation extLoc) {
    }
}

