/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import generic.theme.GColor;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterStatusListener;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.InputVerifier;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FilterFormattedTextField
extends JFormattedTextField {
    private static final Color ERROR_BACKGROUND_COLOR = new GColor("color.bg.version.tracking.filter.formatted.field.error");
    protected static final Color EDITING_BACKGROUND_COLOR = new GColor("color.bg.version.tracking.filter.formatted.field.editing");
    private static final String TEXT_FIELD_BACKGROUND_COLOR_KEY = "TextField.background";
    private Set<FilterStatusListener> listeners = new HashSet<FilterStatusListener>();
    private Filter.FilterEditingStatus currentStatus = Filter.FilterEditingStatus.NONE;
    private final Object defaultValue;
    private final String defaultText;
    private boolean isError;
    private boolean ignoreFocusEditChanges;
    private boolean isProcessingFocusEvent;

    public FilterFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object defaultValue) {
        super(factory);
        this.setValue(defaultValue);
        this.defaultValue = defaultValue;
        this.defaultText = this.getText();
        this.currentStatus = Filter.FilterEditingStatus.NONE;
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FilterFormattedTextField.this.updateText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilterFormattedTextField.this.updateText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FilterFormattedTextField.this.updateText();
            }
        });
        this.addPropertyChangeListener("value", evt -> this.editingFinished());
    }

    public void disableFocusEventProcessing() {
        this.ignoreFocusEditChanges = true;
    }

    @Override
    public int getFocusLostBehavior() {
        if (this.ignoreFocusEditChanges) {
            return -1;
        }
        return super.getFocusLostBehavior();
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        this.isProcessingFocusEvent = true;
        super.processFocusEvent(e);
        this.isProcessingFocusEvent = false;
    }

    public Filter.FilterEditingStatus getFilterStatus() {
        return this.currentStatus;
    }

    public void addFilterStatusListener(FilterStatusListener listener) {
        this.listeners.add(listener);
    }

    private void filterStatusChanged(Filter.FilterEditingStatus status) {
        this.currentStatus = status;
        if (this.listeners == null) {
            return;
        }
        for (FilterStatusListener listener : this.listeners) {
            listener.filterStatusChanged(status);
        }
    }

    private void updateText() {
        if (this.isProcessingFocusEvent) {
            return;
        }
        InputVerifier verifier = this.getInputVerifier();
        if (verifier != null) {
            this.setIsError(!verifier.verify(this));
        }
        this.update();
    }

    @Override
    public void setText(String t) {
        if (SystemUtilities.isEqual((Object)this.getText(), (Object)t)) {
            return;
        }
        super.setText(t);
        this.update();
    }

    public void setIsError(boolean isError) {
        this.isError = isError;
        this.update();
    }

    public void editingFinished() {
        this.update();
    }

    private boolean hasNonDefaultValue() {
        if (this.defaultText == null) {
            return false;
        }
        JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
        if (formatter == null) {
            return this.hasNonDefaultText();
        }
        try {
            Object value = formatter.stringToValue(this.getText());
            if (value == null) {
                return true;
            }
            return !value.equals(this.defaultValue);
        }
        catch (ParseException e) {
            return true;
        }
    }

    private boolean hasNonDefaultText() {
        return !this.getText().equals(this.defaultText);
    }

    private void update() {
        this.setBackground(this.getCurrentColor());
        this.filterStatusChanged(this.currentStatus);
    }

    private Color getCurrentColor() {
        this.updateStatus();
        Color defaultColor = UIManager.getColor(TEXT_FIELD_BACKGROUND_COLOR_KEY);
        if (this.isError) {
            return ERROR_BACKGROUND_COLOR;
        }
        if (this.hasNonDefaultValue()) {
            return EDITING_BACKGROUND_COLOR;
        }
        return defaultColor;
    }

    private void updateStatus() {
        Filter.FilterEditingStatus oldStatus = this.currentStatus;
        this.currentStatus = this.isError ? Filter.FilterEditingStatus.ERROR : (this.hasNonDefaultValue() ? Filter.FilterEditingStatus.APPLIED : Filter.FilterEditingStatus.NONE);
        if (oldStatus != this.currentStatus) {
            this.filterStatusChanged(this.currentStatus);
        }
    }
}

