/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AbstractDemanglerAnalyzer;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.microsoft.MicrosoftDemangler;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;

public class MicrosoftDemanglerAnalyzer
extends AbstractDemanglerAnalyzer {
    private static final String NAME = "Demangler Microsoft";
    private static final String DESCRIPTION = "After a function is created, this analyzer will attempt to demangle the name and apply datatypes to parameters.";
    public static final String OPTION_NAME_APPLY_SIGNATURE = "Apply Function Signatures";
    private static final String OPTION_DESCRIPTION_APPLY_SIGNATURE = "Apply any recovered function signature, in addition to the function name";
    public static final String OPTION_NAME_APPLY_CALLING_CONVENTION = "Apply Function Calling Conventions";
    private static final String OPTION_DESCRIPTION_APPLY_CALLING_CONVENTION = "Apply any recovered function signature calling convention";
    private boolean applyFunctionSignature = true;
    private boolean applyCallingConvention = true;
    private MicrosoftDemangler demangler = new MicrosoftDemangler();

    public MicrosoftDemanglerAnalyzer() {
        super(NAME, DESCRIPTION);
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        return this.demangler.canDemangle(program);
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_APPLY_SIGNATURE, (Object)this.applyFunctionSignature, null, OPTION_DESCRIPTION_APPLY_SIGNATURE);
        options.registerOption(OPTION_NAME_APPLY_CALLING_CONVENTION, (Object)this.applyCallingConvention, null, OPTION_DESCRIPTION_APPLY_CALLING_CONVENTION);
    }

    public void optionsChanged(Options options, Program program) {
        this.applyFunctionSignature = options.getBoolean(OPTION_NAME_APPLY_SIGNATURE, this.applyFunctionSignature);
        this.applyCallingConvention = options.getBoolean(OPTION_NAME_APPLY_CALLING_CONVENTION, this.applyCallingConvention);
    }

    protected DemanglerOptions getOptions() {
        DemanglerOptions options = new DemanglerOptions();
        options.setApplySignature(this.applyFunctionSignature);
        options.setApplyCallingConvention(this.applyCallingConvention);
        return options;
    }

    protected DemangledObject doDemangle(String mangled, DemanglerOptions options, MessageLog log) throws DemangledException {
        DemangledObject demangled = this.demangler.demangle(mangled, options);
        return demangled;
    }
}

