/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DyldCacheDylibExtractor {
    public static ByteProvider extractDylib(long dylibOffset, DyldCacheUtils.SplitDyldCache splitDyldCache, int index, FSRL fsrl, TaskMonitor monitor) throws IOException, MachException {
        PackedSegments packedSegments = new PackedSegments(dylibOffset, splitDyldCache, index, monitor);
        return packedSegments.getByteProvider(fsrl);
    }

    private static class PackedSegments {
        private BinaryReader reader;
        private MachHeader header;
        private Map<SegmentCommand, Integer> packedSegmentStarts = new HashMap<SegmentCommand, Integer>();
        private Map<SegmentCommand, Integer> packedSegmentAdjustments = new HashMap<SegmentCommand, Integer>();
        private byte[] packed;
        private TaskMonitor monitor;

        public PackedSegments(long dylibOffset, DyldCacheUtils.SplitDyldCache splitDyldCache, int index, TaskMonitor monitor) throws MachException, IOException {
            ByteProvider provider = splitDyldCache.getProvider(index);
            this.reader = new BinaryReader(provider, true);
            this.header = new MachHeader(provider, dylibOffset, false).parse(splitDyldCache);
            this.monitor = monitor;
            int packedSize = 0;
            for (SegmentCommand segment : this.header.getAllSegments()) {
                this.packedSegmentStarts.put(segment, packedSize);
                packedSize = (int)((long)packedSize + segment.getFileSize());
                if (!segment.getSegmentName().equals("__TEXT") || segment.getFileOffset() != 0L) continue;
                segment.setFileOffset(dylibOffset);
                this.packedSegmentAdjustments.put(segment, (int)dylibOffset);
            }
            this.packed = new byte[packedSize];
            for (SegmentCommand segment : this.header.getAllSegments()) {
                long segmentSize = segment.getFileSize();
                ByteProvider segmentProvider = this.getSegmentProvider(segment, splitDyldCache);
                if (segment.getFileOffset() + segmentSize > segmentProvider.length()) {
                    segmentSize = segmentProvider.length() - segment.getFileOffset();
                    Msg.warn((Object)this, (Object)(segment.getSegmentName() + " segment extends beyond end of file.  Truncating..."));
                }
                byte[] bytes = segmentProvider.readBytes(segment.getFileOffset(), segmentSize);
                System.arraycopy(bytes, 0, this.packed, this.packedSegmentStarts.get(segment), bytes.length);
            }
            this.fixupMachHeader();
            this.fixupLoadCommands();
        }

        public ByteProvider getByteProvider(FSRL fsrl) {
            return new ByteArrayProvider(this.packed, fsrl);
        }

        public void set(int packedOffset, long value, int size) throws IllegalArgumentException {
            if (size != 4 && size != 8) {
                throw new IllegalArgumentException("Size must be 4 or 8 (got " + size + ")");
            }
            byte[] newBytes = this.toBytes(value, size);
            System.arraycopy(newBytes, 0, this.packed, packedOffset, newBytes.length);
        }

        public void fixup(long fileOffset, long adjustment, int size, SegmentCommand segment) throws IOException, IllegalArgumentException {
            if (size != 4 && size != 8) {
                throw new IllegalArgumentException("Size must be 4 or 8 (got " + size + ")");
            }
            long value = this.reader.readUnsignedValue(fileOffset, size);
            value += adjustment;
            try {
                byte[] newBytes = this.toBytes(this.getPackedOffset(value, segment), size);
                SegmentCommand textSegment = this.header.getSegment("__TEXT");
                System.arraycopy(newBytes, 0, this.packed, (int)this.getPackedOffset(fileOffset, textSegment), newBytes.length);
            }
            catch (NotFoundException e) {
                Msg.warn((Object)this, (Object)e.getMessage());
            }
        }

        public void fixup(long fileOffset, int size, SegmentCommand segment) throws IOException, IllegalArgumentException {
            this.fixup(fileOffset, 0L, size, segment);
        }

        private long getPackedOffset(long fileOffset, SegmentCommand segment) throws NotFoundException {
            Integer segmentStart = this.packedSegmentStarts.get(segment);
            if (segmentStart != null) {
                return fileOffset - segment.getFileOffset() + (long)segmentStart.intValue();
            }
            throw new NotFoundException("Failed to convert DYLD file offset to packed DYLIB offset: " + Long.toHexString(fileOffset));
        }

        private ByteProvider getSegmentProvider(SegmentCommand segment, DyldCacheUtils.SplitDyldCache splitDyldCache) throws IOException {
            for (int i = 0; i < splitDyldCache.size(); ++i) {
                DyldCacheHeader dyldCacheheader = splitDyldCache.getDyldCacheHeader(i);
                for (DyldCacheMappingInfo mappingInfo : dyldCacheheader.getMappingInfos()) {
                    if (!mappingInfo.contains(segment.getVMaddress())) continue;
                    return splitDyldCache.getProvider(i);
                }
            }
            throw new IOException("Failed to find provider for segment: " + segment.getSegmentName());
        }

        private byte[] toBytes(long value, int size) throws IllegalArgumentException {
            if (size != 4 && size != 8) {
                throw new IllegalArgumentException("Size must be 4 or 8 (got " + size + ")");
            }
            LittleEndianDataConverter converter = LittleEndianDataConverter.INSTANCE;
            return size == 8 ? converter.getBytes(value) : converter.getBytes((int)value);
        }

        private void fixupMachHeader() {
            this.set(24, this.header.getFlags() & Integer.MAX_VALUE, 4);
        }

        private void fixupLoadCommands() throws IOException {
            for (LoadCommand cmd : this.header.getLoadCommands()) {
                if (this.monitor.isCancelled()) break;
                switch (cmd.getCommandType()) {
                    case 1: {
                        this.fixupSegment((SegmentCommand)cmd, false);
                        break;
                    }
                    case 25: {
                        this.fixupSegment((SegmentCommand)cmd, true);
                        break;
                    }
                    case 2: {
                        this.fixupSymbolTable((SymbolTableCommand)cmd);
                        break;
                    }
                    case 11: {
                        this.fixupDynamicSymbolTable((DynamicSymbolTableCommand)cmd);
                        break;
                    }
                    case -2147483614: 
                    case 34: {
                        this.fixupDyldInfo((DyldInfoCommand)cmd);
                        break;
                    }
                    case -2147483597: 
                    case -2147483596: 
                    case 29: 
                    case 30: 
                    case 38: 
                    case 41: 
                    case 43: 
                    case 46: {
                        this.fixupLinkEditData((LinkEditDataCommand)cmd);
                    }
                }
            }
        }

        private void fixupSegment(SegmentCommand segment, boolean is64bit) throws IOException {
            long adjustment = this.packedSegmentAdjustments.getOrDefault(segment, 0).intValue();
            if (segment.getFileOffset() > 0L) {
                this.fixup(segment.getStartIndex() + (long)(is64bit ? 40 : 32), adjustment, is64bit ? 8 : 4, segment);
            }
            long sectionStartIndex = segment.getStartIndex() + (long)(is64bit ? 72 : 56);
            for (Section section : segment.getSections()) {
                if (this.monitor.isCancelled()) break;
                if (section.getOffset() > 0 && section.getSize() > 0L) {
                    this.fixup(sectionStartIndex + (long)(is64bit ? 48 : 40), adjustment, 4, segment);
                }
                if (section.getRelocationOffset() > 0) {
                    this.fixup(sectionStartIndex + (long)(is64bit ? 56 : 48), adjustment, 4, segment);
                }
                sectionStartIndex += is64bit ? 80L : 68L;
            }
        }

        private void fixupSymbolTable(SymbolTableCommand cmd) throws IOException {
            SegmentCommand segment = this.header.getSegment("__LINKEDIT");
            if (cmd.getSymbolOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 8L, 4, segment);
            }
            if (cmd.getStringTableOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 16L, 4, segment);
            }
        }

        private void fixupDynamicSymbolTable(DynamicSymbolTableCommand cmd) throws IOException {
            SegmentCommand segment = this.header.getSegment("__LINKEDIT");
            if (cmd.getTableOfContentsOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 32L, 4, segment);
            }
            if (cmd.getModuleTableOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 40L, 4, segment);
            }
            if (cmd.getReferencedSymbolTableOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 48L, 4, segment);
            }
            if (cmd.getIndirectSymbolTableOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 56L, 4, segment);
            }
            if (cmd.getExternalRelocationOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 64L, 4, segment);
            }
            if (cmd.getLocalRelocationOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 72L, 4, segment);
            }
        }

        private void fixupDyldInfo(DyldInfoCommand cmd) throws IOException {
            SegmentCommand segment = this.header.getSegment("__LINKEDIT");
            if (cmd.getRebaseOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 8L, 4, segment);
            }
            if (cmd.getBindOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 16L, 4, segment);
            }
            if (cmd.getWeakBindOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 24L, 4, segment);
            }
            if (cmd.getLazyBindOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 32L, 4, segment);
            }
            if (cmd.getExportOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 40L, 4, segment);
            }
        }

        private void fixupLinkEditData(LinkEditDataCommand cmd) throws IOException {
            SegmentCommand segment = this.header.getSegment("__LINKEDIT");
            if (cmd.getDataOffset() > 0) {
                this.fixup(cmd.getStartIndex() + 8L, 4, segment);
            }
        }
    }
}

