/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.util;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.art.ArtBlock;
import ghidra.file.formats.android.art.ArtCompression;
import ghidra.file.formats.android.art.ArtStorageMode;
import ghidra.file.formats.android.util.Decompressor;
import ghidra.file.formats.android.util.OverlayByteProvider;
import ghidra.file.formats.android.util.OverlayRange;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class DecompressionManager {
    public static BinaryReader decompress(BinaryReader reader, ArtCompression compression, TaskMonitor monitor) throws IOException {
        if (compression.getStorageMode() == ArtStorageMode.kStorageModeUncompressed) {
            return reader;
        }
        OverlayByteProvider provider = new OverlayByteProvider(reader.getByteProvider());
        BinaryReader decompressedReader = new BinaryReader((ByteProvider)provider, reader.isLittleEndian());
        byte[] compressedBytes = reader.readByteArray(compression.getCompressedOffset(), compression.getCompressedSize());
        byte[] decompressedBytes = Decompressor.decompress(compression.getStorageMode(), compressedBytes, compression.getDecompressedSize(), monitor);
        provider.addRange(new OverlayRange(compression.getDecompressedOffset(), decompressedBytes));
        return decompressedReader;
    }

    public static BinaryReader decompress(BinaryReader reader, List<ArtBlock> blocks, TaskMonitor monitor) throws IOException {
        OverlayByteProvider provider = new OverlayByteProvider(reader.getByteProvider());
        BinaryReader decompressedReader = new BinaryReader((ByteProvider)provider, reader.isLittleEndian());
        for (ArtBlock block : blocks) {
            byte[] compressedBytes = reader.readByteArray((long)block.getDataOffset(), block.getDataSize());
            byte[] decompressedBytes = Decompressor.decompress(block.getStorageMode(), compressedBytes, block.getImageSize(), monitor);
            if (decompressedBytes.length != block.getImageSize()) {
                throw new RuntimeException("decompressed length mismatch!");
            }
            provider.addRange(new OverlayRange(block.getImageOffset(), decompressedBytes));
        }
        return decompressedReader;
    }

    public static void decompressOverMemory(Program program, List<ArtBlock> blocks, TaskMonitor monitor) throws Exception {
        for (ArtBlock block : blocks) {
            monitor.checkCancelled();
            Address sourceAddress = program.getMinAddress().add((long)block.getDataOffset());
            byte[] compressedBytes = new byte[block.getDataSize()];
            program.getMemory().getBytes(sourceAddress, compressedBytes);
            byte[] decompressedBytes = Decompressor.decompress(block.getStorageMode(), compressedBytes, block.getImageSize(), monitor);
            Address destinationAddress = program.getMinAddress().add((long)block.getImageOffset());
            AddressSet destinationSet = new AddressSet(destinationAddress, destinationAddress.add((long)decompressedBytes.length));
            AddressSet uncreatedSet = destinationSet.subtract((AddressSetView)program.getMemory());
            for (AddressRange range : uncreatedSet) {
                monitor.checkCancelled();
                program.getMemory().createInitializedBlock(DecompressionManager.toBlockName(range), range.getMinAddress(), range.getLength(), (byte)0, monitor, false);
            }
            program.getMemory().setBytes(destinationAddress, decompressedBytes);
        }
    }

    public static void decompressOverMemory(Program program, ArtCompression compression, TaskMonitor monitor) throws Exception {
        if (compression.getStorageMode() != ArtStorageMode.kStorageModeUncompressed) {
            Address sourceAddress = program.getMinAddress().add(compression.getCompressedOffset());
            byte[] compressedBytes = new byte[compression.getCompressedSize()];
            program.getMemory().getBytes(sourceAddress, compressedBytes);
            byte[] decompressedBytes = Decompressor.decompress(compression.getStorageMode(), compressedBytes, compression.getDecompressedSize(), monitor);
            Address destinationAddress = program.getMinAddress().add(compression.getDecompressedOffset());
            AddressSet destinationSet = new AddressSet(destinationAddress, destinationAddress.add((long)decompressedBytes.length));
            AddressSet uncreatedSet = destinationSet.subtract((AddressSetView)program.getMemory());
            for (AddressRange range : uncreatedSet) {
                monitor.checkCancelled();
                program.getMemory().createInitializedBlock(DecompressionManager.toBlockName(range), range.getMinAddress(), range.getLength(), (byte)0, monitor, false);
            }
            program.getMemory().setBytes(destinationAddress, decompressedBytes);
        }
    }

    private static String toBlockName(AddressRange range) {
        return "decomp_" + range.getMinAddress() + "_" + range.getMaxAddress();
    }
}

