/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.framework.Application;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.jf.baksmali.Baksmali;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.DexFile;

@FileSystemInfo(type="dex2smali", description="Android DEX to SMALI", factory=GFileSystemBaseFactory.class)
public class DexToSmaliFileSystem
extends GFileSystemBase {
    private Map<GFile, File> map = new HashMap<GFile, File>();

    public DexToSmaliFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        File entry = this.map.get(file);
        return new FileByteProvider(entry, file.getFSRL(), AccessMode.READ);
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (GFile file : this.map.keySet()) {
                if (file.getParentFile() != this.root && !file.getParentFile().equals(this.root)) continue;
                roots.add(file);
            }
            return roots;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        for (GFile file : this.map.keySet()) {
            if (file.getParentFile() == null || !file.getParentFile().equals(directory)) continue;
            tmp.add(file);
        }
        return tmp;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        return DexConstants.isDexFile(this.provider);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Converting DEX to SMALI...");
        int rand = new Random().nextInt() & 0xFFFF;
        File outputDir = new File(Application.getUserTempDirectory(), "ghidra_file_system_" + rand);
        DexBackedDexFile dexFile = DexBackedDexFile.fromInputStream((Opcodes)Opcodes.getDefault(), (InputStream)this.provider.getInputStream(0L));
        BaksmaliOptions options = new BaksmaliOptions();
        options.apiLevel = 15;
        options.parameterRegisters = true;
        options.localsDirective = false;
        options.sequentialLabels = false;
        options.debugInfo = true;
        options.codeOffsets = false;
        options.accessorComments = true;
        options.allowOdex = false;
        options.deodex = false;
        options.implicitReferences = false;
        options.normalizeVirtualMethods = false;
        options.registerInfo = 0;
        if (!Baksmali.disassembleDexFile((DexFile)dexFile, (File)outputDir, (int)1, (BaksmaliOptions)options)) {
            throw new IOException("Failed to disassemble DEX file: " + this.provider.getName());
        }
        this.getFileListing(outputDir, this.root, monitor);
    }

    private void getFileListing(File startingDirectory, GFileImpl currentRoot, TaskMonitor monitor) {
        Iterator iterator = FileUtils.iterateFiles((File)startingDirectory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        while (iterator.hasNext()) {
            File f = (File)iterator.next();
            if (monitor.isCancelled()) break;
            monitor.setMessage(f.getName());
            GFileImpl gfile = GFileImpl.fromFilename((GFileSystem)this, (GFile)currentRoot, (String)f.getName(), (boolean)f.isDirectory(), (long)f.length(), null);
            this.storeFile((GFile)gfile, f);
        }
    }

    private void storeFile(GFile file, File entry) {
        if (file == null) {
            return;
        }
        if (file.equals(this.root)) {
            return;
        }
        if (!this.map.containsKey(file) || this.map.get(file) == null) {
            this.map.put(file, entry);
        }
        GFile parentFile = file.getParentFile();
        this.storeFile(parentFile, null);
    }

    public void close() throws IOException {
        this.map.clear();
        super.close();
    }
}

