/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgSession;
import agent.dbgeng.manager.DbgStackFrame;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.model.AbstractDbgModel;
import agent.dbgeng.model.iface1.DbgModelSelectableObject;
import agent.dbgeng.model.iface1.DbgModelTargetExecutionStateful;
import agent.dbgeng.model.iface2.DbgModelTargetConnector;
import agent.dbgeng.model.iface2.DbgModelTargetRoot;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.impl.DbgModelDefaultTargetModelRoot;
import agent.dbgeng.model.impl.DbgModelImpl;
import agent.dbgeng.model.impl.DbgModelTargetAvailableContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetConnectorContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetProcessImpl;
import agent.dbgeng.model.impl.DbgModelTargetSessionContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetSessionImpl;
import agent.dbgeng.model.impl.DbgModelTargetStackFrameImpl;
import agent.dbgeng.model.impl.DbgModelTargetThreadImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Debugger", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Available", type=DbgModelTargetAvailableContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Connectors", type=DbgModelTargetConnectorContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Sessions", type=DbgModelTargetSessionContainerImpl.class, required=true, fixed=true), @TargetAttributeType(type=Void.class)})
public class DbgModelTargetRootImpl
extends DbgModelDefaultTargetModelRoot
implements DbgModelTargetRoot {
    protected final DbgModelTargetAvailableContainerImpl available = new DbgModelTargetAvailableContainerImpl(this);
    protected final DbgModelTargetConnectorContainerImpl connectors = new DbgModelTargetConnectorContainerImpl(this);
    protected final DbgModelTargetSessionContainerImpl sessions = new DbgModelTargetSessionContainerImpl(this);
    protected String debugger = "kd";
    protected DbgModelSelectableObject focus;

    public DbgModelTargetRootImpl(DbgModelImpl impl, TargetObjectSchema schema) {
        super(impl, "Debugger", schema);
        DbgModelTargetConnector defaultConnector = this.connectors.getDefaultConnector();
        this.changeAttributes(List.of(), List.of(this.available, this.connectors, this.sessions), Map.of("_accessible", this.accessible, "_display", "Debugger", "_focus", this, "_supported_attach_kinds", DbgModelTargetProcessImpl.SUPPORTED_KINDS, "_parameters", defaultConnector.getParameters()), "Initialized");
        impl.getManager().addEventsListener(this);
    }

    @Override
    public DbgModelSelectableObject getFocus() {
        return this.focus;
    }

    @Override
    public void setDefaultConnector(DbgModelTargetConnector defaultConnector) {
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", defaultConnector.getParameters()), "Default connector changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(DbgModelSelectableObject sel) {
        boolean doFire;
        DbgModelTargetRootImpl dbgModelTargetRootImpl = this;
        synchronized (dbgModelTargetRootImpl) {
            boolean bl = doFire = !Objects.equals(this.focus, sel);
            if (doFire && this.focus != null) {
                List focusPath = this.focus.getPath();
                List selPath = sel.getPath();
                doFire = !PathUtils.isAncestor((List)selPath, (List)focusPath);
            }
        }
        if (doFire) {
            this.focus = sel;
            this.changeAttributes(List.of(), List.of(), Map.of("_focus", this.focus), "Focus changed");
        }
        return doFire;
    }

    public CompletableFuture<Void> launch(Map<String, ?> args) {
        DbgModelTargetConnector targetConnector = this.connectors.getDefaultConnector();
        return this.model.gateFuture(targetConnector.launch(args)).exceptionally(exc -> {
            throw new DebuggerUserException("Launch failed for " + args);
        });
    }

    @Override
    public CompletableFuture<Void> attach(long pid) {
        DbgProcessImpl process = new DbgProcessImpl(this.getManager());
        return this.model.gateFuture(process.attach(pid)).thenApply(__ -> null);
    }

    @Override
    public void threadStateChanged(DbgThread thread, DbgState state, DbgCause cause, DbgReason reason) {
        DbgModelTargetThread targetThread = (DbgModelTargetThread)this.getModel().getModelObject(thread);
        if (targetThread != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("_event_thread", targetThread), reason.desc());
        }
    }

    @Override
    public void processSelected(DbgProcess process, DbgCause cause) {
        if (process != null) {
            this.objectSelected(process);
        }
    }

    @Override
    public void threadSelected(DbgThread thread, DbgStackFrame frame, DbgCause cause) {
        if (thread != null) {
            this.objectSelected(thread);
            if (frame != null) {
                this.objectSelected(frame);
            }
        }
    }

    public void objectSelected(Object object) {
        AbstractDbgModel model = this.getModel();
        List<String> objPath = this.findObject(object);
        model.fetchModelObject(objPath, DebuggerObjectModel.RefreshBehavior.REFRESH_WHEN_ABSENT).thenAccept(obj -> this.update((TargetObject)obj));
    }

    private List<String> findObject(Object obj) {
        DbgManagerImpl manager = this.getManager();
        List<String> objpath = new ArrayList<String>();
        if (obj == null) {
            return objpath;
        }
        DbgSession session = manager.getCurrentSession();
        if (obj instanceof DbgSession) {
            session = (DbgSession)obj;
        }
        if (session == null) {
            return objpath;
        }
        String skey = DbgModelTargetSessionImpl.keySession(session);
        if (obj instanceof DbgSession || obj instanceof String) {
            objpath = List.of("Sessions", skey);
            return objpath;
        }
        DbgProcess process = manager.getCurrentProcess();
        if (obj instanceof DbgProcess) {
            process = (DbgProcess)obj;
        }
        if (process == null) {
            return objpath;
        }
        String pkey = DbgModelTargetProcessImpl.keyProcess(process);
        if (obj instanceof DbgProcess || obj instanceof DebugProcessId) {
            objpath = List.of("Sessions", skey, "Processes", pkey);
            return objpath;
        }
        DbgThread thread = manager.getCurrentThread();
        if (obj instanceof DbgThread) {
            thread = (DbgThread)obj;
            process = thread.getProcess();
            pkey = DbgModelTargetProcessImpl.keyProcess(process);
        }
        if (thread == null) {
            return objpath;
        }
        String tkey = DbgModelTargetThreadImpl.keyThread(thread);
        if (this.getManager().isKernelMode() && tkey.equals("[0x0]")) {
            pkey = "[0x0]";
        }
        if (obj instanceof DbgThread || obj instanceof DebugThreadId) {
            objpath = List.of("Sessions", skey, "Processes", pkey, "Threads", tkey);
            return objpath;
        }
        if (obj instanceof DbgStackFrame) {
            DbgStackFrame frame = (DbgStackFrame)obj;
            thread = frame.getThread();
            process = thread.getProcess();
            String fkey = DbgModelTargetStackFrameImpl.keyFrame(frame);
            tkey = DbgModelTargetThreadImpl.keyThread(thread);
            pkey = DbgModelTargetProcessImpl.keyProcess(process);
            objpath = List.of("Sessions", skey, "Processes", pkey, "Threads", tkey, "Stack", "Frames", fkey);
            return objpath;
        }
        return objpath;
    }

    private void update(TargetObject obj) {
        if (obj instanceof DbgModelSelectableObject) {
            this.setFocus((DbgModelSelectableObject)obj);
        }
        if (obj instanceof DbgModelTargetExecutionStateful) {
            this.activate((DbgModelTargetExecutionStateful)obj);
        }
    }

    private void activate(DbgModelTargetExecutionStateful stateful) {
        TargetExecutionStateful.TargetExecutionState state = stateful.getExecutionState();
        if (state.equals((Object)TargetExecutionStateful.TargetExecutionState.INACTIVE)) {
            stateful.changeAttributes(List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.ALIVE), "Selected");
            stateful.fetchAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
        }
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }
}

