/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.model.iface1.DbgModelTargetConfigurable;
import agent.dbgeng.model.iface2.DbgModelTargetAvailable;
import agent.dbgeng.model.iface2.DbgModelTargetAvailableContainer;
import agent.dbgeng.model.iface2.DbgModelTargetRoot;
import agent.dbgeng.model.impl.DbgModelTargetAvailableImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

@TargetObjectSchemaInfo(name="AvailableContainer", elements={@TargetElementType(type=DbgModelTargetAvailableImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ALWAYS, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetAvailableContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetAvailableContainer,
DbgModelTargetConfigurable {
    protected final Map<Integer, DbgModelTargetAvailable> attachablesById = new WeakValueHashMap();

    public DbgModelTargetAvailableContainerImpl(DbgModelTargetRoot root) {
        super(root.getModel(), (TargetObject)root, "Available", "AvailableContainer");
        this.changeAttributes(List.of(), Map.of("_base", 16), "Initialized");
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listAvailableProcesses().thenAccept(list -> {
            List available;
            DbgModelTargetAvailableContainerImpl dbgModelTargetAvailableContainerImpl = this;
            synchronized (dbgModelTargetAvailableContainerImpl) {
                available = list.stream().map(this::getTargetAttachableEx).collect(Collectors.toList());
            }
            this.setElements(available, Map.of(), "Refreshed");
        });
    }

    public synchronized DbgModelTargetAvailable getTargetAttachableEx(Pair<Integer, String> pair) {
        return this.attachablesById.computeIfAbsent((Integer)pair.getLeft(), i -> new DbgModelTargetAvailableImpl(this, (Integer)pair.getLeft(), (String)pair.getRight()));
    }

    @Override
    public synchronized DbgModelTargetAvailable getTargetAttachable(int pid) {
        return this.attachablesById.computeIfAbsent(pid, i -> new DbgModelTargetAvailableImpl(this, pid));
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (DbgModelTargetAvailable child : this.attachablesById.values()) {
                        child.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

