/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import ghidra.util.Msg;
import java.math.BigInteger;

public class DbgResolveProcessCommand
extends AbstractDbgCommand<DbgProcess> {
    private DbgProcessImpl process;
    private Long offset;

    public DbgResolveProcessCommand(DbgManagerImpl manager, DbgProcess process) {
        super(manager);
        this.process = (DbgProcessImpl)process;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof DbgConsoleOutputEvent) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public DbgProcess complete(DbgPendingCommand<?> pending) {
        StringBuilder builder = new StringBuilder();
        for (DbgConsoleOutputEvent out : pending.findAllOf(DbgConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        this.parse(builder.toString());
        return this.process;
    }

    private void parse(String result) {
        String[] lines = result.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] fields;
            String line = lines[i];
            if (line.contains("PROCESS") && (fields = line.trim().split("\\s+")).length > 1 && fields[0].equals("PROCESS")) {
                BigInteger val = new BigInteger(fields[1], 16);
                this.offset = val.longValue();
                this.process.setOffset(this.offset);
            }
            if (!line.contains("Cid:")) continue;
            fields = line.trim().split("\\s+");
            if (fields.length <= 3 || !fields[2].equals("Cid:")) break;
            Long pid = Long.parseLong(fields[3], 16);
            this.process.setPid(pid);
            break;
        }
        if (this.offset == null) {
            Msg.error((Object)this, (Object)result);
        }
    }

    @Override
    public void invoke() {
        if (this.process != null) {
            DebugControl control = this.manager.getControl();
            Long key = this.process.getOffset() != null ? this.process.getOffset() : this.process.getPid();
            control.execute("!process " + Long.toHexString(key) + " 0");
        }
    }
}

