/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.client;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugEventCallbacks;
import agent.dbgeng.dbgeng.DebugOutputCallbacks;
import agent.dbgeng.dbgeng.DebugServerId;
import agent.dbgeng.impl.dbgeng.client.DebugClientImpl4;
import agent.dbgeng.impl.dbgeng.client.DebugClientInternal;
import agent.dbgeng.impl.dbgeng.event.WrapCallbackIDebugEventCallbacksWide;
import agent.dbgeng.impl.dbgeng.io.WrapCallbackIDebugOutputCallbacksWide;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.jna.dbgeng.client.IDebugClient5;
import agent.dbgeng.jna.dbgeng.event.ListenerIDebugEventCallbacksWide;
import agent.dbgeng.jna.dbgeng.io.ListenerIDebugOutputCallbacksWide;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import ghidra.comm.util.BitmaskSet;

public class DebugClientImpl5
extends DebugClientImpl4 {
    private final IDebugClient5 jnaClient;

    public DebugClientImpl5(IDebugClient5 jnaClient) {
        super(jnaClient);
        this.jnaClient = jnaClient;
    }

    @Override
    public void createProcess(DebugServerId si, String commandLine, String initialDirectory, String environment, BitmaskSet<DebugClient.DebugCreateFlags> createFlags, BitmaskSet<DebugClient.DebugEngCreateFlags> engCreateFlags, BitmaskSet<DebugClient.DebugVerifierFlags> verifierFlags) {
        WinDef.ULONGLONG ullServer = new WinDef.ULONGLONG(si.id);
        DbgEngNative.DEBUG_CREATE_PROCESS_OPTIONS options = new DbgEngNative.DEBUG_CREATE_PROCESS_OPTIONS();
        options.CreateFlags = new WinDef.ULONG(createFlags.getBitmask());
        options.EngCreateFlags = new WinDef.ULONG(engCreateFlags.getBitmask());
        options.VerifierFlags = new WinDef.ULONG(verifierFlags.getBitmask());
        WinDef.ULONG ulOptionsBufferSize = new WinDef.ULONG((long)options.size());
        WString cmdLine = new WString(commandLine);
        WString initDir = initialDirectory == null ? null : new WString(initialDirectory);
        WString env = environment == null ? null : new WString(environment);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.CreateProcess2Wide(ullServer, cmdLine, options, ulOptionsBufferSize, initDir, env));
    }

    @Override
    public void attachKernel(long flags, String options) {
        WinDef.ULONG connectFlags = new WinDef.ULONG(flags);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.AttachKernelWide(connectFlags, new WString(options)));
    }

    @Override
    public void startProcessServer(String options) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.StartProcessServerWide(new WinDef.ULONG((long)DebugClientInternal.DebugClass.USER_WINDOWS.ordinal()), new WString(options), null));
    }

    @Override
    public DebugServerId connectProcessServer(String options) {
        WinDef.ULONGLONGByReference pulServer = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.ConnectProcessServerWide(new WString(options), pulServer));
        return new DebugServerId(pulServer.getValue().longValue());
    }

    @Override
    public void setOutputCallbacks(DebugOutputCallbacks cb) {
        ListenerIDebugOutputCallbacksWide listener = null;
        if (cb != null) {
            WrapCallbackIDebugOutputCallbacksWide callback = new WrapCallbackIDebugOutputCallbacksWide(cb);
            listener = new ListenerIDebugOutputCallbacksWide(callback);
            callback.setListener(listener);
        }
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.SetOutputCallbacksWide(listener));
        this.listenerOutput = listener;
    }

    @Override
    public void setEventCallbacks(DebugEventCallbacks cb) {
        ListenerIDebugEventCallbacksWide listener = null;
        if (cb != null) {
            WrapCallbackIDebugEventCallbacksWide callback = new WrapCallbackIDebugEventCallbacksWide(this, cb);
            listener = new ListenerIDebugEventCallbacksWide(callback);
            callback.setListener(listener);
        }
        COMUtils.checkRC((WinNT.HRESULT)this.jnaClient.SetEventCallbacksWide(listener));
        this.listenerEvent = listener;
    }
}

