/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PublicSymbolInformation
extends AbstractSymbolInformation {
    private int symbolHashLength;
    private int addressMapLength;
    private int numThunks;
    private int thunkSize;
    private int iSectionThunkTable;
    private int offsetThunkTable;
    private int numSections;
    private int thunkMapLength;
    private int thunkTableLength;
    private int sectionMapLength;
    private List<Long> addressMapSymbolOffsets = new ArrayList<Long>();
    private Map<Integer, Integer> thunkTargetOffsetsByTableOffset = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> absoluteOffsetsBySectionNumber = new HashMap<Integer, Integer>();

    public PublicSymbolInformation(AbstractPdb pdbIn) {
        super(pdbIn);
    }

    public int getNumThunks() {
        return this.numThunks;
    }

    public int getThunkTableSection() {
        return this.iSectionThunkTable;
    }

    public int getThunkTableOffset() {
        return this.offsetThunkTable;
    }

    public int getThunkSize() {
        return this.thunkSize;
    }

    public int getThunkTableLength() {
        return this.thunkTableLength;
    }

    public int getNumSections() {
        return this.numSections;
    }

    public List<Long> getAddressMapSymbolOffsets() {
        return this.addressMapSymbolOffsets;
    }

    @Override
    void deserialize(int streamNumber) throws IOException, PdbException, CancelledException {
        super.deserialize(streamNumber);
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNumber);
        this.deserializePubHeader(reader);
        PdbByteReader hashReader = reader.getSubPdbByteReader(this.symbolHashLength);
        this.deserializeHashTable(hashReader);
        PdbByteReader addressMapReader = reader.getSubPdbByteReader(this.addressMapLength);
        this.deserializeAddressMap(addressMapReader);
        PdbByteReader thunkMapReader = reader.getSubPdbByteReader(this.thunkMapLength);
        this.deserializeThunkMap(thunkMapReader);
        this.sectionMapLength = reader.numRemaining();
        if (this.sectionMapLength % 8 != 0) {
            throw new PdbException("sectionMapLength size not multiple of 8");
        }
        this.numSections = this.sectionMapLength / 8;
        PdbByteReader sectionMapReader = reader.getSubPdbByteReader(this.sectionMapLength);
        this.deserializeSectionMap(sectionMapReader);
        this.generateSymbolsList();
    }

    @Override
    void dump(Writer writer) throws IOException, CancelledException {
        StringBuilder builder = new StringBuilder();
        builder.append("PublicSymbolInformation-------------------------------------\n");
        this.dumpPubHeader(builder);
        this.dumpHashHeader(builder);
        this.dumpHashBasics(builder);
        this.dumpHashRecords(builder);
        this.dumpAddressMap(builder);
        this.dumpThunkMap(builder);
        this.dumpSectionMap(builder);
        builder.append("\nEnd PublicSymbolInformation---------------------------------\n");
        writer.write(builder.toString());
    }

    private void deserializeAddressMap(PdbByteReader reader) throws PdbException, CancelledException {
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            this.addressMapSymbolOffsets.add(Long.valueOf(reader.parseInt()));
        }
    }

    private void dumpAddressMap(StringBuilder builder) {
        builder.append("AddressMapSymbolOffsets-------------------------------------\n");
        builder.append("numAddressMapSymbolOffsets: " + this.addressMapSymbolOffsets.size() + "\n");
        int num = 0;
        for (Long val : this.addressMapSymbolOffsets) {
            builder.append(String.format("0X%08X: 0X%012X\n", num++, val));
        }
        builder.append("\nEnd AddressMapSymbolOffsets---------------------------------\n");
    }

    private void deserializeThunkMap(PdbByteReader reader) throws PdbException, CancelledException {
        int count = 0;
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            int targetOffset = reader.parseInt();
            int mapTableOffset = count * this.thunkSize + this.offsetThunkTable;
            this.thunkTargetOffsetsByTableOffset.put(mapTableOffset, targetOffset);
        }
    }

    private void dumpThunkMap(StringBuilder builder) {
        builder.append("ThunkMap----------------------------------------------------\n");
        builder.append("numThunkTargetOffsetsByTableOffset: " + this.thunkTargetOffsetsByTableOffset.size() + "\n");
        for (Map.Entry<Integer, Integer> entry : this.thunkTargetOffsetsByTableOffset.entrySet()) {
            builder.append(String.format("0X%08X  0X%08X\n", entry.getKey(), entry.getValue()));
        }
        builder.append("\nEnd ThunkMap------------------------------------------------\n");
    }

    private void deserializeSectionMap(PdbByteReader reader) throws PdbException, CancelledException {
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            int offset = reader.parseInt();
            int section = reader.parseUnsignedShortVal();
            reader.skip(2);
            this.absoluteOffsetsBySectionNumber.put(section, offset);
        }
    }

    private void dumpSectionMap(StringBuilder builder) throws CancelledException {
        builder.append("SectionMap--------------------------------------------------\n");
        builder.append("numAbsoluteOffsetsBySectionNumber: " + this.absoluteOffsetsBySectionNumber.size() + "\n");
        for (Map.Entry<Integer, Integer> entry : this.absoluteOffsetsBySectionNumber.entrySet()) {
            this.pdb.checkCancelled();
            builder.append(String.format("0X%08X  0X%08X\n", entry.getKey(), entry.getValue()));
        }
        builder.append("\nEnd SectionMap----------------------------------------------\n");
    }

    private void dumpPubHeader(StringBuilder builder) {
        builder.append("PublicSymbolInformationHeader-------------------------------\n");
        builder.append("symbolHashLength: ");
        builder.append(this.symbolHashLength);
        builder.append("\naddressMapLength: ");
        builder.append(this.addressMapLength);
        builder.append("\nnumThunks: ");
        builder.append(this.numThunks);
        builder.append("\nthunkSize: ");
        builder.append(this.thunkSize);
        builder.append("\niSectionThunkTable: ");
        builder.append(this.iSectionThunkTable);
        builder.append("\noffsetThunkTable: ");
        builder.append(this.offsetThunkTable);
        builder.append("\nnumSections: ");
        builder.append(this.numSections);
        builder.append("\nthunkMapLength: ");
        builder.append(this.thunkMapLength);
        builder.append("\nthunkTableLength: ");
        builder.append(this.thunkTableLength);
        builder.append("\nEnd PublicSymbolInformationHeader---------------------------\n");
    }

    private void deserializePubHeader(PdbByteReader reader) throws PdbException {
        this.symbolHashLength = reader.parseInt();
        this.addressMapLength = reader.parseInt();
        long val = reader.parseUnsignedIntVal();
        if (val > Integer.MAX_VALUE) {
            throw new PdbException("Cannot support large unsigned integer num thunks");
        }
        this.numThunks = (int)val;
        this.thunkSize = reader.parseInt();
        this.iSectionThunkTable = reader.parseUnsignedShortVal();
        reader.skip(2);
        this.offsetThunkTable = reader.parseInt();
        val = reader.parseUnsignedIntVal();
        this.numSections = (int)val;
        val = 4 * this.numThunks;
        if (val > Integer.MAX_VALUE) {
            throw new PdbException("Cannot support large unsigned integer for thunk map length");
        }
        this.thunkMapLength = (int)val;
        val = this.thunkSize * this.numThunks;
        if (val > Integer.MAX_VALUE) {
            throw new PdbException("Cannot support large unsigned integer for thunk table length");
        }
        this.thunkTableLength = (int)val;
    }
}

