/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13CrossScopeExports;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class C13CrossScopeImports
extends C13Section {
    private List<CrossScopeImport> crossScopeImports = new ArrayList<CrossScopeImport>();

    static C13CrossScopeImports parse(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        return new C13CrossScopeImports(reader, ignore, monitor);
    }

    protected C13CrossScopeImports(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws CancelledException, PdbException {
        super(ignore);
        while (reader.numRemaining() >= CrossScopeImport.getBaseRecordSize()) {
            monitor.checkCancelled();
            CrossScopeImport crossImport = new CrossScopeImport(reader);
            this.crossScopeImports.add(crossImport);
        }
        if (reader.hasMore()) {
            Msg.debug(C13CrossScopeExports.class, (Object)String.format("Num Extra C13CrossScopeExports bytes: %d", reader.numRemaining()));
        }
    }

    List<CrossScopeImport> getCrossScopeImports() {
        return this.crossScopeImports;
    }

    public String toString() {
        return String.format("%s: num cross-scope imports = %d", this.getClass().getSimpleName(), this.crossScopeImports.size());
    }

    @Override
    void dump(Writer writer) throws IOException {
        writer.write("C13CrossScopeImports----------------------------------------\n");
        for (CrossScopeImport crossScopeImport : this.crossScopeImports) {
            writer.write(crossScopeImport.toString());
            writer.write(10);
        }
        writer.write("End C13CrossScopeImports------------------------------------\n");
    }

    static class CrossScopeImport {
        private int offsetObjectFilePath;
        private long numCrossReferences;
        private List<Long> referenceIds;

        private static int getBaseRecordSize() {
            return 8;
        }

        CrossScopeImport(PdbByteReader reader) throws PdbException {
            this.offsetObjectFilePath = reader.parseInt();
            this.numCrossReferences = reader.parseUnsignedIntVal();
            this.referenceIds = new ArrayList<Long>();
            for (long i = 0L; i < this.numCrossReferences; ++i) {
                this.referenceIds.add(reader.parseUnsignedIntVal());
            }
        }

        long getOffsetObjectFilePath() {
            return this.offsetObjectFilePath;
        }

        long getNumCrossReferences() {
            return this.numCrossReferences;
        }

        List<Long> getReferenceIds() {
            return this.referenceIds;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("0x%08x, %5d", this.offsetObjectFilePath, this.numCrossReferences));
            for (Long id : this.referenceIds) {
                builder.append(String.format(" 0x%08x", id));
            }
            return builder.toString();
        }
    }
}

