/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaFrame;
import agent.frida.manager.FridaReason;
import agent.frida.manager.FridaState;
import agent.frida.model.iface2.FridaModelTargetProcess;
import agent.frida.model.iface2.FridaModelTargetStack;
import agent.frida.model.iface2.FridaModelTargetStackFrame;
import agent.frida.model.iface2.FridaModelTargetThread;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetStackFrameImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="Stack", elementResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=FridaModelTargetStackFrameImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class FridaModelTargetStackImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetStack {
    protected final FridaModelTargetThread thread;
    public static final String NAME = "Stack";
    protected final Map<Integer, FridaModelTargetStackFrameImpl> framesByLevel = new WeakValueHashMap();

    public FridaModelTargetStackImpl(FridaModelTargetThread thread, FridaModelTargetProcess process) {
        super(thread.getModel(), (TargetObject)thread, NAME, NAME);
        this.thread = thread;
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listStackFrames(this.thread.getThread()).thenAccept(f -> {
            List frames;
            FridaModelTargetStackImpl fridaModelTargetStackImpl = this;
            synchronized (fridaModelTargetStackImpl) {
                frames = f.values().stream().map(this::getTargetFrame).collect(Collectors.toList());
            }
            this.setElements(frames, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized FridaModelTargetStackFrame getTargetFrame(FridaFrame frame) {
        return this.framesByLevel.compute(frame.getFrameID(), (l, f) -> {
            if (f == null) {
                return new FridaModelTargetStackFrameImpl(this, this.thread, frame);
            }
            f.setFrame(frame);
            return f;
        });
    }

    public void threadStateChangedSpecific(FridaState state, FridaReason reason) {
        if (state.equals((Object)FridaState.FRIDA_THREAD_STOPPED)) {
            this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS).thenAccept(__ -> {
                for (TargetObject element : this.getCachedElements().values()) {
                    if (!(element instanceof FridaModelTargetStackFrame)) continue;
                    FridaModelTargetStackFrameImpl frame = (FridaModelTargetStackFrameImpl)element;
                    frame.threadStateChangedSpecific(state, reason);
                }
            });
        }
    }
}

