/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaSection;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class FridaListModuleSectionsCommand
extends AbstractFridaCommand<Map<String, FridaSection>> {
    protected final FridaModule module;
    private Map<String, FridaSection> sections;

    public FridaListModuleSectionsCommand(FridaManagerImpl manager, FridaModule module) {
        super(manager);
        this.module = module;
    }

    @Override
    public Map<String, FridaSection> complete(FridaPendingCommand<?> pending) {
        return this.sections;
    }

    @Override
    public void invoke() {
        this.sections = new HashMap<String, FridaSection>();
        this.manager.loadScript(this, "list_module_ranges", "result = Process.findModuleByAddress('" + this.module.getRangeAddress() + "').enumerateRanges('---');");
        for (FridaSection section : this.sections.values()) {
            this.sections.put(FridaClient.getId(section), section);
        }
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        FridaSection section = new FridaSection(this.module);
        JsonObject sectionDetails = element.getAsJsonObject();
        section.setRangeAddress(sectionDetails.get("base").getAsString());
        section.setRangeSize(sectionDetails.get("size").getAsLong());
        section.setProtection(sectionDetails.get("protection").getAsString());
        JsonObject sectionFile = (JsonObject)sectionDetails.get("file");
        if (sectionFile != null) {
            section.setFilePath(sectionFile.get("path").getAsString());
            section.setFileOffset(sectionFile.get("offset").getAsLong());
            section.setFileSize(sectionFile.get("size").getAsLong());
        }
        this.sections.put(FridaClient.getId(section), section);
    }
}

