/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager;

import agent.frida.manager.FridaFileSpec;
import agent.frida.manager.FridaProcess;

public class FridaMemoryRegionInfo {
    private FridaProcess process;
    private String protection;
    private String rangeAddress;
    private Long rangeSize;
    private FridaFileSpec fileSpec;

    public FridaMemoryRegionInfo(FridaProcess process) {
        this.process = process;
    }

    public String getProtection() {
        return this.protection;
    }

    public void setProtection(String protection) {
        this.protection = protection;
    }

    public String getRangeAddress() {
        return this.rangeAddress;
    }

    public void setRangeAddress(String rangeAddress) {
        this.rangeAddress = rangeAddress;
    }

    public Long getRangeSize() {
        return this.rangeSize;
    }

    public void setRangeSize(Long rangeSize) {
        this.rangeSize = rangeSize;
    }

    public String getFilePath() {
        return this.fileSpec.getPath();
    }

    public void setFilePath(String filePath) {
        this.fileSpec = new FridaFileSpec(filePath);
    }

    public Long getFileOffset() {
        return this.fileSpec.getOffset();
    }

    public void setFileOffset(Long fileOffset) {
        this.fileSpec.setOffset(fileOffset);
    }

    public Long getFileSize() {
        return this.fileSpec.getSize();
    }

    public void setFileSize(Long fileSize) {
        this.fileSpec.setSize(fileSize);
    }

    public Boolean isReadable() {
        return this.protection.contains("r");
    }

    public Boolean isWritable() {
        return this.protection.contains("w");
    }

    public Boolean isExecutable() {
        return this.protection.contains("x");
    }

    public FridaFileSpec getFileSpec() {
        return this.fileSpec;
    }

    public FridaProcess getProcess() {
        return this.process;
    }
}

