/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamList;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class ParamListStandard
implements ParamList {
    protected int numgroup;
    protected int pointermax;
    protected boolean thisbeforeret;
    protected boolean splitMetatype;
    protected ParamEntry[] entry;
    protected AddressSpace spacebase;

    private int findEntry(Address loc, int size) {
        for (int i = 0; i < this.entry.length; ++i) {
            if (this.entry[i].getMinSize() > size || this.entry[i].justifiedContain(loc, size) != 0) continue;
            return i;
        }
        return -1;
    }

    protected VariableStorage assignAddress(Program program, DataType tp, int[] status, boolean ishiddenret, boolean isindirect) {
        if (tp == null) {
            tp = DataType.DEFAULT;
        }
        if (VoidDataType.isVoidDataType(tp)) {
            return VariableStorage.VOID_STORAGE;
        }
        int sz = tp.getLength();
        if (sz == 0) {
            return VariableStorage.UNASSIGNED_STORAGE;
        }
        for (ParamEntry element : this.entry) {
            DynamicVariableStorage store;
            int grp = element.getGroup();
            if (status[grp] < 0 || element.getType() != 8 && ParamEntry.getMetatype(tp) != element.getType()) continue;
            VarnodeData res = new VarnodeData();
            status[grp] = element.getAddrBySlot(status[grp], tp.getLength(), res);
            if (res.space == null) continue;
            if (element.isExclusion()) {
                for (int group : element.getAllGroups()) {
                    status[group] = -1;
                }
                if (element.isFloatExtended()) {
                    sz = element.getSize();
                }
            }
            try {
                if (res.space.getType() == 6) {
                    Varnode[] pieces = element.getJoinPieces(sz);
                    store = pieces != null ? new DynamicVariableStorage((ProgramArchitecture)program, false, pieces) : DynamicVariableStorage.getUnassignedDynamicStorage(false);
                } else {
                    Address addr = res.space.getAddress(res.offset);
                    store = ishiddenret ? new DynamicVariableStorage((ProgramArchitecture)program, AutoParameterType.RETURN_STORAGE_PTR, addr, sz) : (isindirect ? new DynamicVariableStorage((ProgramArchitecture)program, true, addr, sz) : new DynamicVariableStorage((ProgramArchitecture)program, false, addr, sz));
                }
            }
            catch (InvalidInputException e) {
                break;
            }
            return store;
        }
        if (ishiddenret) {
            return DynamicVariableStorage.getUnassignedDynamicStorage(AutoParameterType.RETURN_STORAGE_PTR);
        }
        return DynamicVariableStorage.getUnassignedDynamicStorage(isindirect);
    }

    @Override
    public void assignMap(Program prog, DataType[] proto, ArrayList<VariableStorage> res, boolean addAutoParams) {
        int i;
        int[] status = new int[this.numgroup];
        for (i = 0; i < this.numgroup; ++i) {
            status[i] = 0;
        }
        if (addAutoParams && res.size() == 2) {
            ProgramBasedDataTypeManager dtm = prog.getDataTypeManager();
            Pointer pointer = dtm.getPointer(proto[0]);
            VariableStorage store = this.assignAddress(prog, pointer, status, true, false);
            res.set(1, store);
        }
        for (i = 1; i < proto.length; ++i) {
            VariableStorage store;
            if (this.pointermax != 0 && proto[i] != null && proto[i].getLength() > this.pointermax) {
                ProgramBasedDataTypeManager dtm = prog.getDataTypeManager();
                Pointer pointer = dtm.getPointer(proto[i]);
                store = this.assignAddress(prog, pointer, status, false, true);
            } else {
                store = this.assignAddress(prog, proto[i], status, false, false);
            }
            res.add(store);
        }
    }

    @Override
    public VariableStorage[] getPotentialRegisterStorage(Program prog) {
        ArrayList<VariableStorage> res = new ArrayList<VariableStorage>();
        for (ParamEntry element : this.entry) {
            ParamEntry pe = element;
            if (!pe.isExclusion() || !pe.getSpace().isRegisterSpace()) continue;
            VariableStorage var = null;
            try {
                var = new VariableStorage((ProgramArchitecture)prog, pe.getSpace().getAddress(pe.getAddressBase()), pe.getSize());
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (var == null) continue;
            res.add(var);
        }
        VariableStorage[] arres = new VariableStorage[res.size()];
        res.toArray(arres);
        return arres;
    }

    @Override
    public void encode(Encoder encoder, boolean isInput) throws IOException {
        encoder.openElement(isInput ? ElementId.ELEM_INPUT : ElementId.ELEM_OUTPUT);
        if (this.pointermax != 0) {
            encoder.writeSignedInteger(AttributeId.ATTRIB_POINTERMAX, this.pointermax);
        }
        if (this.thisbeforeret) {
            encoder.writeBool(AttributeId.ATTRIB_THISBEFORERETPOINTER, true);
        }
        if (isInput && !this.splitMetatype) {
            encoder.writeBool(AttributeId.ATTRIB_SEPARATEFLOAT, false);
        }
        int curgroup = -1;
        for (ParamEntry el : this.entry) {
            if (!(curgroup < 0 || el.isGrouped() && el.getGroup() == curgroup)) {
                encoder.closeElement(ElementId.ELEM_GROUP);
                curgroup = -1;
            }
            if (el.isGrouped() && curgroup < 0) {
                encoder.openElement(ElementId.ELEM_GROUP);
                curgroup = el.getGroup();
            }
            el.encode(encoder);
        }
        if (curgroup >= 0) {
            encoder.closeElement(ElementId.ELEM_GROUP);
        }
        encoder.closeElement(isInput ? ElementId.ELEM_INPUT : ElementId.ELEM_OUTPUT);
    }

    private void parsePentry(XmlPullParser parser, CompilerSpec cspec, ArrayList<ParamEntry> pe, int groupid, boolean splitFloat, boolean grouped) throws XmlParseException {
        int[] groupSet;
        int maxgroup;
        int lastMeta = -1;
        if (!pe.isEmpty()) {
            ParamEntry lastEntry = pe.get(pe.size() - 1);
            lastMeta = lastEntry.isGrouped() ? 8 : lastEntry.getType();
        }
        ParamEntry pentry = new ParamEntry(groupid);
        pe.add(pentry);
        pentry.restoreXml(parser, cspec, pe, grouped);
        if (splitFloat) {
            int currentMeta;
            int n = currentMeta = grouped ? 8 : pentry.getType();
            if (lastMeta != currentMeta && lastMeta > currentMeta) {
                throw new XmlParseException("parameter list entries must be ordered by metatype");
            }
        }
        if (pentry.getSpace().isStackSpace()) {
            this.spacebase = pentry.getSpace();
        }
        if ((maxgroup = (groupSet = pentry.getAllGroups())[groupSet.length - 1] + 1) > this.numgroup) {
            this.numgroup = maxgroup;
        }
    }

    private void parseGroup(XmlPullParser parser, CompilerSpec cspec, ArrayList<ParamEntry> pe, int groupid, boolean splitFloat) throws XmlParseException {
        XmlElement el = parser.start(new String[]{"group"});
        int basegroup = this.numgroup;
        int count = 0;
        while (parser.peek().isStart()) {
            this.parsePentry(parser, cspec, pe, basegroup, splitFloat, true);
            ++count;
            ParamEntry lastEntry = pe.get(pe.size() - 1);
            if (lastEntry.getSpace().getType() != 6) continue;
            throw new XmlParseException("<pentry> in the join space not allowed in <group> tag");
        }
        for (int i = 1; i < count; ++i) {
            ParamEntry curEntry = pe.get(pe.size() - 1 - i);
            for (int j = 0; j < i; ++j) {
                ParamEntry.orderWithinGroup(curEntry, pe.get(pe.size() - 1 - j));
            }
        }
        parser.end(el);
    }

    @Override
    public void restoreXml(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        XmlElement el;
        ArrayList<ParamEntry> pe = new ArrayList<ParamEntry>();
        this.numgroup = 0;
        this.spacebase = null;
        this.pointermax = 0;
        this.thisbeforeret = false;
        this.splitMetatype = true;
        XmlElement mainel = parser.start(new String[0]);
        String attribute = mainel.getAttribute("pointermax");
        if (attribute != null) {
            this.pointermax = SpecXmlUtils.decodeInt((String)attribute);
        }
        if ((attribute = mainel.getAttribute("thisbeforeretpointer")) != null) {
            this.thisbeforeret = SpecXmlUtils.decodeBoolean((String)attribute);
        }
        if ((attribute = mainel.getAttribute("separatefloat")) != null) {
            this.splitMetatype = SpecXmlUtils.decodeBoolean((String)attribute);
        }
        while ((el = parser.peek()).isStart()) {
            if (el.getName().equals("pentry")) {
                this.parsePentry(parser, cspec, pe, this.numgroup, this.splitMetatype, false);
                continue;
            }
            if (!el.getName().equals("group")) continue;
            this.parseGroup(parser, cspec, pe, this.numgroup, this.splitMetatype);
        }
        parser.end(mainel);
        this.entry = new ParamEntry[pe.size()];
        pe.toArray(this.entry);
    }

    @Override
    public int getStackParameterAlignment() {
        for (ParamEntry pentry : this.entry) {
            if (!pentry.getSpace().isStackSpace()) continue;
            return pentry.getAlign();
        }
        return -1;
    }

    @Override
    public Long getStackParameterOffset() {
        for (ParamEntry element : this.entry) {
            ParamEntry pentry = element;
            if (pentry.isExclusion() || !pentry.getSpace().isStackSpace()) continue;
            long res = pentry.getAddressBase();
            if (pentry.isReverseStack()) {
                res += (long)pentry.getSize();
            }
            res = pentry.getSpace().truncateOffset(res);
            return res;
        }
        return null;
    }

    @Override
    public boolean possibleParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        if (loc == null) {
            return false;
        }
        int num = this.findEntry(loc, size);
        if (num == -1) {
            return false;
        }
        ParamEntry curentry = this.entry[num];
        res.slot = curentry.getSlot(loc, 0);
        res.slotsize = curentry.isExclusion() ? curentry.getAllGroups().length : (size - 1) / curentry.getAlign() + 1;
        return true;
    }

    @Override
    public boolean isEquivalent(ParamList obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParamListStandard op2 = (ParamListStandard)obj;
        if (this.entry.length != op2.entry.length) {
            return false;
        }
        for (int i = 0; i < this.entry.length; ++i) {
            if (this.entry[i].isEquivalent(op2.entry[i])) continue;
            return false;
        }
        if (this.numgroup != op2.numgroup || this.pointermax != op2.pointermax) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.spacebase, (Object)op2.spacebase)) {
            return false;
        }
        return this.thisbeforeret == op2.thisbeforeret;
    }

    @Override
    public boolean isThisBeforeRetPointer() {
        return this.thisbeforeret;
    }
}

