/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.BooleanField;
import db.DBHandle;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import db.Table;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class OldStackRefDBAdpater {
    static final String STACK_REF_TABLE_NAME = "Stack References";
    static final Schema STACK_REF_SCHEMA = new Schema(0, "Key", new Field[]{LongField.INSTANCE, ShortField.INSTANCE, BooleanField.INSTANCE, ShortField.INSTANCE}, new String[]{"From Address", "Op Index", "User Defined", "Stack Offset"});
    static final int FROM_ADDR_COL = 0;
    static final int OP_INDEX_COL = 1;
    static final int USER_DEFINED_COL = 2;
    static final int STACK_OFFSET_COL = 3;
    private Table refTable;

    private OldStackRefDBAdpater(DBHandle handle) throws VersionException {
        this.refTable = handle.getTable(STACK_REF_TABLE_NAME);
        if (this.refTable == null) {
            throw new VersionException("Missing Table: Stack References");
        }
        if (this.refTable.getSchema().getVersion() != 0) {
            throw new VersionException(2, false);
        }
    }

    RecordIterator getRecords() throws IOException {
        return this.refTable.iterator();
    }

    int getRecordCount() {
        return this.refTable.getRecordCount();
    }

    private void moveTable(DBHandle handle, TaskMonitor monitor) throws IOException, CancelledException {
        DBHandle tmpHandle = handle.getScratchPad();
        Table newRefTable = tmpHandle.createTable(STACK_REF_TABLE_NAME, STACK_REF_SCHEMA);
        monitor.setMessage("Processing Old Stack References...");
        monitor.initialize((long)this.refTable.getRecordCount());
        int count = 0;
        RecordIterator iter = this.refTable.iterator();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            newRefTable.putRecord(iter.next());
            monitor.setProgress((long)(++count));
        }
        handle.deleteTable(STACK_REF_TABLE_NAME);
        this.refTable = newRefTable;
    }

    static OldStackRefDBAdpater getAdapter(DBHandle dbHandle, int openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        OldStackRefDBAdpater adapter = new OldStackRefDBAdpater(dbHandle);
        if (openMode == 3) {
            adapter.moveTable(dbHandle, monitor);
        }
        return adapter;
    }
}

