/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import db.DBHandle;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressMapDBAdapterNoTable;
import ghidra.program.database.map.AddressMapDBAdapterV0;
import ghidra.program.database.map.AddressMapDBAdapterV1;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

abstract class AddressMapDBAdapter {
    static String TABLE_NAME = "ADDRESS MAP";
    static final int CURRENT_VERSION = 1;
    AddressMap oldAddrMap;

    AddressMapDBAdapter() {
    }

    static AddressMapDBAdapter getAdapter(DBHandle handle, int openMode, AddressFactory factory, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new AddressMapDBAdapterV1(handle, factory, true);
        }
        try {
            return new AddressMapDBAdapterV1(handle, factory, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            AddressMapDBAdapter adapter = AddressMapDBAdapter.findReadOnlyAdapter(handle, factory);
            if (openMode == 3) {
                adapter = AddressMapDBAdapter.upgrade(handle, adapter, factory, monitor);
            }
            return adapter;
        }
    }

    static AddressMapDBAdapter findReadOnlyAdapter(DBHandle handle, AddressFactory factory) throws IOException {
        try {
            return new AddressMapDBAdapterV0(handle, factory);
        }
        catch (VersionException e) {
            return new AddressMapDBAdapterNoTable(handle, factory);
        }
    }

    static AddressMapDBAdapter upgrade(DBHandle handle, AddressMapDBAdapter oldAdapter, AddressFactory factory, TaskMonitor monitor) throws VersionException, IOException {
        monitor.setMessage("Upgrading Address Map...");
        List<AddressMapEntry> entries = oldAdapter.getEntries();
        oldAdapter.deleteTable();
        monitor.initialize((long)entries.size());
        AddressMapDBAdapterV1 newAdapter = new AddressMapDBAdapterV1(handle, factory, true);
        newAdapter.oldAddrMap = oldAdapter.oldAddrMap;
        ((AddressMapDBAdapter)newAdapter).setEntries(entries);
        return newAdapter;
    }

    abstract void deleteTable() throws IOException;

    abstract Address[] addBaseAddress(Address var1, long var2);

    abstract Address[] getBaseAddresses(boolean var1) throws IOException;

    abstract List<AddressMapEntry> getEntries() throws IOException;

    abstract void setEntries(List<AddressMapEntry> var1) throws IOException;

    abstract void clearAll() throws IOException;

    abstract void setAddressFactory(AddressFactory var1);

    abstract void renameOverlaySpace(String var1, String var2) throws IOException;

    abstract void deleteOverlaySpace(String var1) throws IOException;

    static class AddressMapEntry {
        int index;
        String name;
        int segment;
        boolean deleted;

        public AddressMapEntry(int index, String name, int segment, boolean deleted) {
            this.index = index;
            this.name = name;
            this.segment = segment;
            this.deleted = deleted;
        }
    }
}

