/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.util;

import docking.framework.ApplicationInformationDisplayFactory;
import generic.theme.LafType;
import generic.theme.ThemeManager;
import ghidra.util.SystemUtilities;
import java.awt.Font;
import java.awt.Taskbar;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class LookAndFeelUtils {
    private LookAndFeelUtils() {
    }

    public static void installGlobalOverrides() {
        Integer fontOverride = SystemUtilities.getFontSizeOverrideValue();
        if (fontOverride != null) {
            LookAndFeelUtils.setGlobalFontSizeOverride(fontOverride);
        }
    }

    private static void setGlobalFontSizeOverride(int fontSize) {
        UIDefaults defaults = UIManager.getDefaults();
        Set set = defaults.entrySet();
        for (Map.Entry entry : set) {
            Font currentFont;
            Object key = entry.getKey();
            if (key.toString().toLowerCase().indexOf("font") == -1 || (currentFont = defaults.getFont(key)) == null) continue;
            Font newFont = currentFont.deriveFont((float)fontSize);
            UIManager.put(key, newFont);
        }
    }

    public static void performPlatformSpecificFixups() {
        Taskbar taskbar;
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
            taskbar.setIconImage(ApplicationInformationDisplayFactory.getLargestWindowIcon());
        }
    }

    public static LafType getLookAndFeelType() {
        return ThemeManager.getInstance().getLookAndFeelType();
    }

    public static boolean isUsingAquaUI(ComponentUI UI) {
        return ThemeManager.getInstance().isUsingAquaUI(UI);
    }

    public static boolean isUsingNimbusUI() {
        return ThemeManager.getInstance().isUsingNimbusUI();
    }
}

