/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textarea;

import generic.theme.GThemeDefaults;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JTextArea;

public class HintTextArea
extends JTextArea {
    private String hint;

    public HintTextArea(String hint) {
        this.hint = hint;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.setAttributes();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getText().isEmpty() && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor((Color)GThemeDefaults.Colors.Messages.HINT);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.hint != null) {
                g2.drawString(this.hint, 5, 12);
            }
        }
    }

    protected void setAttributes() {
        this.setFont(this.getFont().deriveFont(0));
        this.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
    }
}

