/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.list;

import docking.widgets.AbstractGCellRenderer;
import generic.theme.GThemeDefaults;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.List;
import java.util.function.Function;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class GListCellRenderer<E>
extends AbstractGCellRenderer
implements ListCellRenderer<E> {
    public static <E> GListCellRenderer<E> createDefaultCellTextRenderer(final Function<E, String> cellToTextMappingFunction) {
        return new GListCellRenderer<E>(){

            @Override
            protected String getItemText(E value) {
                return (String)cellToTextMappingFunction.apply(value);
            }
        };
    }

    public GListCellRenderer() {
        this.setShouldAlternateRowBackgroundColors(false);
    }

    protected String getItemText(E value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean hasFocus) {
        this.setText(this.getItemText(value));
        this.setHorizontalAlignment(value instanceof Number ? 4 : 2);
        ListModel<? extends E> model = list.getModel();
        this.configureFont(list, model, index);
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
            this.setOpaque(true);
        } else {
            boolean isDropRow;
            this.setForegroundColor(list, model, value);
            JList.DropLocation dropLocation = list.getDropLocation();
            boolean bl = isDropRow = dropLocation != null && dropLocation.isInsert() && dropLocation.getIndex() == index;
            if (isDropRow) {
                this.setBackground((Color)GThemeDefaults.Colors.Palette.CYAN);
            } else {
                this.setBackground(this.getAlternatingBackgroundColor(list, index));
            }
        }
        this.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
        return this;
    }

    protected void setForegroundColor(JList<? extends E> list, ListModel<? extends E> model, Object value) {
        this.setForeground(list.getForeground());
    }

    protected void configureFont(JList<? extends E> list, ListModel<? extends E> model, int index) {
        this.setFont(this.defaultFont);
    }

    public Dimension computePlainTextListCellDimensions(JList<? extends E> list, List<E> items, int minWidth, int minHeight) {
        this.configureFont(list, list.getModel(), 0);
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int maxWidth = minWidth;
        for (E item : items) {
            String text = this.getItemText(item).toString();
            maxWidth = Math.max(maxWidth, metrics.stringWidth(text));
        }
        return new Dimension(maxWidth, Math.max(metrics.getHeight(), minHeight));
    }
}

