/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.DockingWindowManager;
import docking.theme.gui.ExportThemeDialog;
import docking.widgets.OptionDialog;
import docking.widgets.SelectFromListDialog;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import generic.theme.DiscoverableGTheme;
import generic.theme.GTheme;
import generic.theme.LafType;
import generic.theme.ThemeManager;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class ThemeUtils {
    public static boolean askToSaveThemeChanges(ThemeManager themeManager) {
        if (themeManager.hasThemeChanges()) {
            int result = OptionDialog.showOptionDialog(null, "Save Theme Changes?", "You have made changes to the current theme.\n Do you want to save or abort your changes", "Save", "Abort");
            if (result == 0) {
                return false;
            }
            if (result == 1) {
                return ThemeUtils.saveThemeChanges(themeManager);
            }
            themeManager.restoreThemeValues();
        }
        return true;
    }

    public static boolean saveThemeChanges(ThemeManager themeManager) {
        GTheme activeTheme = themeManager.getActiveTheme();
        String name = activeTheme.getName();
        while (!ThemeUtils.canSaveToName(themeManager, name).booleanValue()) {
            if (ThemeUtils.shouldCancelSave(themeManager, name)) {
                return false;
            }
            if ((name = ThemeUtils.getNameFromUser(name)) != null) continue;
            return false;
        }
        return ThemeUtils.saveCurrentValues(themeManager, name);
    }

    private static boolean shouldCancelSave(ThemeManager themeManager, String name) {
        if (name.isBlank()) {
            int result = OptionDialog.showOptionNoCancelDialog(null, "Invalid Theme Name", "The theme name can't be blank!\nDo you want to enter a new name?", "Yes", "Cancel", 3);
            return result != 1;
        }
        GTheme existing = themeManager.getTheme(name);
        if (existing instanceof DiscoverableGTheme) {
            int result = OptionDialog.showOptionNoCancelDialog(null, "Unmodifiable Theme", "The current theme is unmodifiable!\nDo you want to save as a new theme?", "Yes", "Cancel", 3);
            return result != 1;
        }
        return false;
    }

    public static void importTheme(ThemeManager themeManager) {
        GhidraFileChooser chooser = new GhidraFileChooser(null);
        chooser.setTitle("Choose Theme File");
        chooser.setApproveButtonToolTipText("Select File");
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        chooser.setFileFilter((GhidraFileFilter)ExtensionFileFilter.forExtensions((String)"Ghidra Theme Files", (String[])new String[]{GTheme.FILE_EXTENSION, GTheme.ZIP_FILE_EXTENSION}));
        File file = chooser.getSelectedFile();
        chooser.dispose();
        if (file == null) {
            return;
        }
        ThemeUtils.importTheme(themeManager, file);
    }

    static void importTheme(ThemeManager themeManager, File themeFile) {
        if (!ThemeUtils.askToSaveThemeChanges(themeManager)) {
            return;
        }
        GTheme startingTheme = themeManager.getActiveTheme();
        try {
            GTheme imported = GTheme.loadTheme((File)themeFile);
            themeManager.setTheme(imported);
            if (!ThemeUtils.saveThemeChanges(themeManager)) {
                themeManager.setTheme(startingTheme);
            }
        }
        catch (IOException e) {
            Msg.showError(ThemeUtils.class, null, (String)"Error Importing Theme File", (Object)("Error encountered importing file: " + themeFile.getAbsolutePath()), (Throwable)e);
        }
    }

    public static void exportTheme(ThemeManager themeManager) {
        int result;
        if (!ThemeUtils.askToSaveThemeChanges(themeManager)) {
            return;
        }
        boolean hasExternalIcons = !themeManager.getActiveTheme().getExternalIconFiles().isEmpty();
        String message = "Export as zip file? (You are not using any external icons so the zip\nfile would only contain a single theme file.)";
        if (hasExternalIcons) {
            message = "Export as zip file? (You have external icons so a zip file is required if you\nwant to include the icons in the export.)";
        }
        if ((result = OptionDialog.showOptionDialog(null, "Export as Zip?", message, "Export Zip", "Export File", 3)) == 0) {
            return;
        }
        boolean exportAsZip = result == 1;
        ExportThemeDialog dialog = new ExportThemeDialog(themeManager, exportAsZip);
        DockingWindowManager.showDialog(dialog);
    }

    public static void deleteTheme(ThemeManager themeManager) {
        ArrayList<GTheme> savedThemes = new ArrayList<GTheme>(themeManager.getAllThemes().stream().filter(t -> t.getFile() != null).toList());
        if (savedThemes.isEmpty()) {
            Msg.showInfo(ThemeUtils.class, null, (String)"Delete Theme", (Object)"There are no deletable themes");
            return;
        }
        GTheme selectedTheme = SelectFromListDialog.selectFromList(savedThemes, "Delete Theme", "Select theme to delete", t -> t.getName());
        if (selectedTheme == null) {
            return;
        }
        if (themeManager.getActiveTheme().equals((Object)selectedTheme)) {
            Msg.showWarn(ThemeUtils.class, null, (String)"Delete Failed", (Object)"Cannot delete the active theme.");
            return;
        }
        GTheme fileTheme = selectedTheme;
        int result = OptionDialog.showYesNoDialog(null, "Delete Theme: " + fileTheme.getName() + "?", "Are you sure you want to delete theme " + fileTheme.getName());
        if (result == 1) {
            themeManager.deleteTheme(fileTheme);
        }
    }

    private static String getNameFromUser(String name) {
        InputDialog inputDialog = new InputDialog("Create Theme", "New Theme Name", name);
        DockingWindowManager.showDialog(inputDialog);
        return inputDialog.getValue();
    }

    public static Boolean canSaveToName(ThemeManager themeManager, String name) {
        if (name.isBlank()) {
            return false;
        }
        GTheme existing = themeManager.getTheme(name);
        if (existing == null) {
            return true;
        }
        if (existing instanceof DiscoverableGTheme) {
            return false;
        }
        if (existing.getFile() == null) {
            return true;
        }
        int result = OptionDialog.showYesNoDialog(null, "Overwrite Existing Theme?", "Do you want to overwrite the existing theme file for \"" + name + "\"?");
        return result == 1;
    }

    private static boolean saveCurrentValues(ThemeManager themeManager, String themeName) {
        GTheme activeTheme = themeManager.getActiveTheme();
        File file = ThemeUtils.getSaveFile(themeName);
        if (!file.exists()) {
            Msg.info(ThemeUtils.class, (Object)("Saving theme to " + file));
        }
        LafType lafType = activeTheme.getLookAndFeelType();
        boolean useDarkDefaults = activeTheme.useDarkDefaults();
        LafType currentLafType = themeManager.getLookAndFeelType();
        if (currentLafType != activeTheme.getLookAndFeelType()) {
            lafType = currentLafType;
            useDarkDefaults = lafType.usesDarkDefaults();
        }
        GTheme newTheme = new GTheme(file, themeName, lafType, useDarkDefaults);
        newTheme.load(themeManager.getNonDefaultValues());
        try {
            newTheme.save();
            themeManager.addTheme(newTheme);
            themeManager.setTheme(newTheme);
        }
        catch (IOException e) {
            Msg.showError(ThemeUtils.class, null, (String)"I/O Error", (Object)("Error writing theme file: " + newTheme.getFile().getAbsolutePath()), (Throwable)e);
            return false;
        }
        return true;
    }

    public static File getSaveFile(String themeName) {
        File dir = Application.getUserSettingsDirectory();
        File themeDir = new File(dir, "themes");
        if (!themeDir.exists()) {
            themeDir.mkdir();
        }
        String cleanedName = themeName.replaceAll(" ", "_") + "." + GTheme.FILE_EXTENSION;
        return new File(themeDir, cleanedName);
    }
}

