/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import generic.theme.GColor;
import generic.util.action.ReservedKeyBindings;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class ComponentThemeInspectorAction
extends DockingAction {
    public ComponentThemeInspectorAction() {
        super("Component Theme Inspector", "DockingWindows", false);
        this.createReservedKeyBinding(ReservedKeyBindings.COMPONENT_THEME_INFO_KEY);
        DockingWindowManager.getHelpService().excludeFromHelp((Object)this);
    }

    private Object getMouseOverObject() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Point mouseLocation = pointerInfo.getLocation();
        Object lastObject = DockingWindowManager.getMouseOverObject();
        if (!(lastObject instanceof Component)) {
            return lastObject;
        }
        Component c = (Component)lastObject;
        Window w = c instanceof Window ? (Window)c : SwingUtilities.windowForComponent(c);
        if (w != null) {
            SwingUtilities.convertPointFromScreen(mouseLocation, w);
            Component deepestComponent = SwingUtilities.getDeepestComponentAt(w, mouseLocation.x, mouseLocation.y);
            if (deepestComponent != null) {
                return deepestComponent;
            }
        }
        return lastObject;
    }

    @Override
    public void actionPerformed(ActionContext context) {
        Object object = this.getMouseOverObject();
        if (!(object instanceof Component)) {
            Msg.debug((Object)this, (Object)("Mouse not over a component: " + object));
            return;
        }
        Entry entry = null;
        ArrayList<TableEntry> tree = new ArrayList<TableEntry>();
        for (Component component = (Component)object; component != null; component = component.getParent()) {
            Entry next = component instanceof JTable ? new TableEntry((JTable)component) : (component instanceof JTree ? new TreeEntry((JTree)component) : new Entry(component));
            if (entry != null) {
                entry.parent = next;
            }
            entry = next;
            tree.add((TableEntry)entry);
        }
        Collections.reverse(tree);
        StringBuilder buffy = new StringBuilder("\n");
        for (int i = 0; i < tree.size() - 1; ++i) {
            Entry e = (Entry)tree.get(i);
            e.toString(buffy, i + 1);
        }
        buffy.append('\n');
        Entry hoveredEntry = (Entry)tree.get(tree.size() - 1);
        hoveredEntry.toString(buffy, 0);
        buffy.append('\n');
        Msg.debug((Object)this, (Object)buffy);
    }

    private void print(StringBuilder buffy, Component component, int indent) {
        String name;
        Color bg = component.getBackground();
        Color fg = component.getForeground();
        String clazz = component.getClass().getSimpleName();
        if (clazz.isEmpty()) {
            clazz = component.getClass().getName();
        }
        Object id = (name = component.getName()) == null ? clazz : clazz + "; name = " + name;
        Object indentMarker = "";
        String spacer = "";
        if (indent > 0) {
            indentMarker = Integer.toString(indent) + ") ";
            String asString = Integer.toString(indent);
            int length = asString.length();
            spacer = StringUtils.repeat((char)' ', (int)(length + 2));
        } else {
            spacer = "\t";
        }
        String bgText = Objects.toString(bg);
        if (bg instanceof GColor) {
            GColor gColor = (GColor)bg;
            bgText = gColor.toDebugString();
        }
        String fgText = Objects.toString(fg);
        if (fg instanceof GColor) {
            GColor gColor = (GColor)fg;
            fgText = gColor.toDebugString();
        }
        String tabs = "\n" + StringUtils.repeat((char)' ', (int)(indent * 3));
        buffy.append(tabs).append((String)indentMarker).append((String)id).append(tabs).append(spacer).append("bg: ").append(bgText).append(tabs).append(spacer).append("fg: ").append(fgText).append('\n');
    }

    private void debugComponent(Component component) {
    }

    private void debugTable(TableCellRenderer renderer, Component component, Component rendererComponent) {
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    private class TableEntry
    extends Entry {
        private JTable table;

        TableEntry(JTable table) {
            super(table);
            this.table = table;
        }

        @Override
        public void toString(StringBuilder buffy, int indent) {
            ComponentThemeInspectorAction.this.print(buffy, this.component, indent);
            if (!this.isLeaf(indent)) {
                return;
            }
            int row = this.table.rowAtPoint(this.mouseLocation);
            int col = this.table.columnAtPoint(this.mouseLocation);
            if (row != -1 && col != -1) {
                TableCellRenderer renderer = this.table.getCellRenderer(row, col);
                Component rendererComponent = this.table.prepareRenderer(renderer, row, col);
                ComponentThemeInspectorAction.this.debugTable(renderer, this.component, rendererComponent);
                ComponentThemeInspectorAction.this.print(buffy, rendererComponent, indent);
            }
        }
    }

    private class TreeEntry
    extends Entry {
        private JTree tree;

        TreeEntry(JTree tree) {
            super(tree);
            this.tree = tree;
        }

        @Override
        public void toString(StringBuilder buffy, int indent) {
            ComponentThemeInspectorAction.this.print(buffy, this.component, indent);
            if (!this.isLeaf(indent)) {
                return;
            }
            TreeCellRenderer renderer = this.tree.getCellRenderer();
            int row = this.tree.getClosestRowForLocation(this.mouseLocation.x, this.mouseLocation.y);
            if (row != -1) {
                TreePath path = this.tree.getPathForRow(row);
                Object pathValue = path.getLastPathComponent();
                Component rendererComponent = renderer.getTreeCellRendererComponent(this.tree, pathValue, this.tree.isRowSelected(row), this.tree.isExpanded(row), this.tree.getModel().isLeaf(pathValue), row, true);
                ComponentThemeInspectorAction.this.print(buffy, rendererComponent, indent);
            }
        }
    }

    private class Entry {
        private Entry parent;
        protected Component component;
        protected Point mouseLocation;

        Entry(Component component) {
            this.component = component;
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            this.mouseLocation = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(this.mouseLocation, component);
        }

        public void toString(StringBuilder buffy, int indent) {
            ComponentThemeInspectorAction.this.debugComponent(this.component);
            ComponentThemeInspectorAction.this.print(buffy, this.component, indent);
        }

        protected boolean isLeaf(int indent) {
            return indent == 0;
        }
    }
}

