/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.gadp;

import agent.lldb.gadp.LldbGadpServer;
import ghidra.dbg.gadp.server.AbstractGadpLocalDebuggerModelFactory;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.program.model.listing.Program;
import java.util.List;

@ConfigurableFactory.FactoryDescription(brief="lldb via GADP", htmlDetails="Connect to lldb.\nThis is best for most macOS and iOS targets, but supports many others.\nThis will protect Ghidra's JVM by using a subprocess to access the native API.")
public class LldbGadpDebuggerModelFactory
extends AbstractGadpLocalDebuggerModelFactory {
    public int getPriority(Program program) {
        String exe;
        String osname = System.getProperty("os.name").toLowerCase();
        if (!(osname.contains("mac os x") || osname.contains("linux") || osname.contains("windows"))) {
            return -1;
        }
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 35;
    }

    protected String getThreadName() {
        return "Local LLDB Agent stdout";
    }

    protected Class<?> getServerClass() {
        return LldbGadpServer.class;
    }

    protected void completeCommandLine(List<String> cmd) {
        cmd.add(this.getServerClass().getCanonicalName());
        cmd.addAll(List.of("-H", this.host));
        cmd.addAll(List.of("-p", Integer.toString(this.port)));
    }
}

