/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.util;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class ProtobufOneofByTypeHelper<M extends AbstractMessage, B extends Message.Builder> {
    private final Descriptors.OneofDescriptor descriptor;
    private final Map<Descriptors.Descriptor, Descriptors.FieldDescriptor> fieldsByType;

    public static Descriptors.OneofDescriptor findOneofByName(Descriptors.Descriptor descriptor, String name) {
        for (Descriptors.OneofDescriptor desc : descriptor.getOneofs()) {
            if (!name.equals(desc.getName())) continue;
            return desc;
        }
        return null;
    }

    public static <M extends AbstractMessage, B extends Message.Builder> ProtobufOneofByTypeHelper<M, B> create(M exampleMessage, B exampleBuilder, String oneofName) {
        Descriptors.Descriptor typeDesc = exampleMessage.getDescriptorForType();
        if (exampleBuilder.getDescriptorForType() != typeDesc) {
            throw new IllegalArgumentException("Example message and builder must have the same message type");
        }
        Descriptors.OneofDescriptor oneofDesc = ProtobufOneofByTypeHelper.findOneofByName(typeDesc, oneofName);
        if (oneofDesc == null) {
            throw new NoSuchElementException("oneof " + oneofName + " in " + typeDesc);
        }
        return new ProtobufOneofByTypeHelper<M, B>(oneofDesc);
    }

    private ProtobufOneofByTypeHelper(Descriptors.OneofDescriptor descriptor) {
        this.descriptor = descriptor;
        HashMap<Descriptors.Descriptor, Descriptors.FieldDescriptor> descsByType = new HashMap<Descriptors.Descriptor, Descriptors.FieldDescriptor>();
        for (Descriptors.FieldDescriptor desc : descriptor.getFields()) {
            Descriptors.Descriptor type = desc.getMessageType();
            if (type != null && descsByType.put(type, desc) == null) continue;
            throw new IllegalArgumentException(this.getClass() + " requires each fields in " + descriptor + " to be a unique message type");
        }
        this.fieldsByType = Map.copyOf(descsByType);
    }

    public Descriptors.FieldDescriptor getFieldForTypeOf(MessageOrBuilder value) {
        Descriptors.FieldDescriptor field = this.fieldsByType.get(value.getDescriptorForType());
        if (field == null) {
            throw new IllegalArgumentException("No field in " + this.descriptor + " has type of " + value);
        }
        return field;
    }

    public void set(B builder, Message value) {
        builder.setField(this.getFieldForTypeOf((MessageOrBuilder)value), (Object)value);
    }

    public void set(B builder, Message.Builder value) {
        builder.setField(this.getFieldForTypeOf((MessageOrBuilder)value), (Object)value.build());
    }

    public <MI extends Message> MI expect(M outer, MI exampleInner) {
        Descriptors.FieldDescriptor field = outer.getOneofFieldDescriptor(this.descriptor);
        if (field == null || field.getMessageType() != exampleInner.getDescriptorForType()) {
            return null;
        }
        return (MI)((Message)outer.getField(field));
    }
}

