/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.model.impl;

import agent.dbgeng.model.iface2.DbgModelTargetAvailable;
import agent.dbgeng.model.iface2.DbgModelTargetAvailableContainer;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgmodel.model.impl.DbgModel2TargetAvailableImpl;
import agent.dbgmodel.model.impl.DbgModel2TargetObjectImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DbgModel2TargetAvailableContainerImpl
extends DbgModel2TargetObjectImpl
implements DbgModelTargetAvailableContainer {
    protected final Map<Integer, DbgModelTargetAvailable> attachablesById = new WeakValueHashMap();

    public DbgModel2TargetAvailableContainerImpl(DbgModelTargetObject obj) {
        super(obj.getModel(), (TargetObject)obj, "Available", "AvailableContainer");
    }

    @Override
    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getManager().listAvailableProcesses().thenAccept(list -> {
            List available;
            DbgModel2TargetAvailableContainerImpl dbgModel2TargetAvailableContainerImpl = this;
            synchronized (dbgModel2TargetAvailableContainerImpl) {
                available = list.stream().map(this::getTargetAttachableEx).collect(Collectors.toList());
            }
            this.setElements(available, Map.of(), "Refreshed");
        });
    }

    @Override
    public CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        HashMap<String, Object> nmap = new HashMap<String, Object>();
        return this.addModelObjectAttributes(nmap);
    }

    public synchronized DbgModelTargetAvailable getTargetAttachableEx(Pair<Integer, String> pair) {
        return this.attachablesById.computeIfAbsent((Integer)pair.getLeft(), i -> new DbgModel2TargetAvailableImpl(this, (Integer)pair.getLeft(), (String)pair.getRight()));
    }

    public synchronized DbgModelTargetAvailable getTargetAttachable(int pid) {
        return this.attachablesById.computeIfAbsent(pid, i -> new DbgModel2TargetAvailableImpl(this, pid));
    }
}

