/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model.iface2;

import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import ghidra.dbg.agent.InvalidatableTargetObjectIf;
import ghidra.dbg.jdi.manager.JdiManager;
import ghidra.dbg.jdi.model.JdiModelImpl;
import ghidra.dbg.jdi.model.JdiModelTargetField;
import ghidra.dbg.jdi.model.JdiModelTargetMethod;
import ghidra.dbg.jdi.model.JdiModelTargetObjectReference;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.jdi.model.JdiModelTargetThread;
import ghidra.dbg.jdi.model.JdiModelTargetType;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.CollectionUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface JdiModelTargetObject
extends TargetObject,
InvalidatableTargetObjectIf {
    public static final String THREAD_ATTRIBUTE_NAME = "Thread";
    public static final String THIS_OBJECT_ATTRIBUTE_NAME = "This";
    public static final String LOCATION_ATTRIBUTE_NAME = "Location";

    public JdiModelImpl getModelImpl();

    default public JdiManager getManager() {
        return this.getModelImpl().getManager();
    }

    default public CompletableFuture<Void> init(Map<String, Object> map) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchElements();

    public CompletableFuture<? extends Map<String, ?>> fetchAttributes();

    public CollectionUtils.Delta<?, ?> changeAttributes(List<String> var1, Map<String, ?> var2, String var3);

    default public JdiModelTargetObject getInstance(Mirror object) {
        JdiModelTargetObject targetObject = this.getTargetObject(object);
        if (targetObject == null) {
            if (object instanceof ThreadReference) {
                ThreadReference thread = (ThreadReference)object;
                targetObject = new JdiModelTargetThread(this, thread, this.acceptsElement(THREAD_ATTRIBUTE_NAME));
            } else if (object instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)object;
                targetObject = new JdiModelTargetObjectReference(this, ref, this.acceptsElement("ObjectReference"));
            } else if (object instanceof ReferenceType) {
                ReferenceType reftype = (ReferenceType)object;
                targetObject = new JdiModelTargetReferenceType(this, reftype, this.acceptsElement("ReferenceType"));
            } else if (object instanceof Field) {
                Field field = (Field)object;
                targetObject = new JdiModelTargetField(this, field, this.acceptsElement("Field"));
            } else if (object instanceof Method) {
                Method method = (Method)object;
                targetObject = new JdiModelTargetMethod(this, method, this.acceptsElement("Method"));
            } else if (object instanceof Type) {
                Type type = (Type)object;
                targetObject = new JdiModelTargetType(this, type, this.acceptsElement("Type"));
            } else {
                throw new RuntimeException();
            }
        }
        return targetObject;
    }

    default public boolean acceptsElement(String schemaName) {
        TargetObjectSchema schema = this.getSchema();
        if (schema.equals(EnumerableTargetObjectSchema.ANY)) {
            return true;
        }
        TargetObjectSchema.SchemaName s = schema.getElementSchema(schemaName);
        return s.toString().equals(schemaName);
    }

    public JdiModelTargetObject getTargetObject(Object var1);

    public Object getObject();
}

