/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.LocalVariable;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetLocalVariable;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="LocalVariableContainer", elements={@TargetElementType(type=JdiModelTargetLocalVariable.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetLocalVariableContainer
extends JdiModelTargetObjectImpl {
    private List<LocalVariable> vars;
    protected final Map<String, JdiModelTargetLocalVariable> variablesByName = new HashMap<String, JdiModelTargetLocalVariable>();

    public JdiModelTargetLocalVariableContainer(JdiModelTargetObject parent, String name, List<LocalVariable> vars) {
        super(parent, name);
        this.vars = vars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingVariables(Map<String, LocalVariable> byName) {
        List locations;
        JdiModelTargetLocalVariableContainer jdiModelTargetLocalVariableContainer = this;
        synchronized (jdiModelTargetLocalVariableContainer) {
            locations = byName.values().stream().map(this::getTargetVariable).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetLocalVariable loc : locations) {
            fence.include(loc.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), locations, Map.of(), "Refreshed"));
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        HashMap<String, LocalVariable> map = new HashMap<String, LocalVariable>();
        try {
            for (LocalVariable var : this.vars) {
                map.put(var.name(), var);
            }
            this.variablesByName.keySet().retainAll(map.keySet());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.updateUsingVariables(map);
    }

    protected synchronized JdiModelTargetLocalVariable getTargetVariable(LocalVariable var) {
        return this.variablesByName.computeIfAbsent(var.name(), n -> new JdiModelTargetLocalVariable(this, var, true));
    }

    public synchronized JdiModelTargetLocalVariable getTargetVariableIfPresent(String name) {
        return this.variablesByName.get(name);
    }
}

