/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.Expr;
import ghidra.pcode.struct.LValInternal;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.PointerDataType;

class FieldExpr
extends Expr
implements LValInternal {
    private final RValInternal composite;
    private final int offset;

    private FieldExpr(StructuredSleigh ctx, RValInternal composite, int offset, DataType type) {
        super(ctx, type);
        this.composite = composite;
        this.offset = offset;
    }

    private FieldExpr(StructuredSleigh ctx, RValInternal parent, DataTypeComponent component) {
        this(ctx, parent, component.getOffset(), (DataType)new PointerDataType(component.getDataType()));
    }

    protected FieldExpr(StructuredSleigh ctx, RValInternal parent, String name) {
        this(ctx, parent, ctx.findComponent(parent, name));
    }

    @Override
    public StructuredSleigh.LVal cast(DataType type) {
        return new FieldExpr(this.ctx, this.composite, this.offset, type);
    }

    public String toString() {
        return "<Field " + this.composite + " + 0x" + Long.toString(this.offset, 16) + ">";
    }

    @Override
    public StringTree generate(RValInternal parent) {
        StringTree st = new StringTree();
        st.append("(");
        st.append(this.composite.generate(this));
        st.append(" + ");
        st.append(Integer.toString(this.offset));
        st.append(")");
        return st;
    }
}

