/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.JavaBinarySearcher;
import db.JavaBinarySearcher2;

public class TestSpeed {
    private static byte[] createBuf() {
        byte[] buf = new byte[16384];
        for (int i = 0; i < 2048; ++i) {
            TestSpeed.putLong(buf, i, i);
        }
        return buf;
    }

    private static void putLong(byte[] data, int index, long v) {
        int i = index * 8;
        data[i + 0] = (byte)(v >> 56);
        data[i + 1] = (byte)(v >> 48);
        data[i + 2] = (byte)(v >> 40);
        data[i + 3] = (byte)(v >> 32);
        data[i + 4] = (byte)(v >> 24);
        data[i + 5] = (byte)(v >> 16);
        data[i + 6] = (byte)(v >> 8);
        data[i + 7] = (byte)v;
    }

    public static void main(String[] args) {
        byte[] buf = TestSpeed.createBuf();
        TestSpeed.test1(buf);
        TestSpeed.test2(buf);
    }

    private static void test1(byte[] buf) {
        JavaBinarySearcher search1 = new JavaBinarySearcher();
        int nKeys = 2048;
        long start = System.currentTimeMillis();
        for (int j = 0; j < 1000; ++j) {
            for (int i = 0; i < nKeys; ++i) {
                int index = search1.binarySearch(buf, i, nKeys);
                if (index == i) continue;
                System.out.println("search failed");
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("Done, time = " + (end - start));
    }

    private static void test2(byte[] buf) {
        JavaBinarySearcher2 search1 = new JavaBinarySearcher2();
        int nKeys = 2048;
        long start = System.currentTimeMillis();
        for (int j = 0; j < 1000; ++j) {
            for (int i = 0; i < nKeys; ++i) {
                int index = search1.binarySearch(buf, i, nKeys);
                if (index == i) continue;
                System.out.println("search failed");
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("Done, time = " + (end - start));
    }
}

