/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.plugin.core.reloc.RelocationFixupHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;

public class ElfeBPFRelocationFixupHandler
extends RelocationFixupHandler {
    public boolean processRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        return this.process64BitRelocation(program, relocation, oldImageBase, newImageBase);
    }

    public boolean handlesProgram(Program program) {
        if (!"Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            return false;
        }
        Language language = program.getLanguage();
        if (language.getLanguageDescription().getSize() != 64) {
            return false;
        }
        Processor processor = language.getProcessor();
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"eBPF"));
    }
}

