/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.breakpoint.GdbBreakpointInfo;
import agent.gdb.manager.breakpoint.GdbBreakpointLocation;
import agent.gdb.manager.breakpoint.GdbBreakpointType;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetBreakpointContainer;
import agent.gdb.model.impl.GdbModelTargetBreakpointLocation;
import agent.gdb.model.impl.GdbModelTargetStackFrame;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetDeletable;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerMap;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="BreakpointSpec", attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetBreakpointSpec
extends DefaultTargetObject<GdbModelTargetBreakpointLocation, GdbModelTargetBreakpointContainer>
implements TargetBreakpointSpec,
TargetDeletable {
    protected final GdbModelImpl impl;
    protected final long number;
    protected GdbBreakpointInfo info;
    protected boolean enabled;
    protected String expression;
    protected String display;
    protected TargetBreakpointSpecContainer.TargetBreakpointKindSet kinds;
    protected final Map<Long, GdbModelTargetBreakpointLocation> breaksBySub = new WeakValueHashMap();
    protected final ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> actions = new ListenerSet<TargetBreakpointSpec.TargetBreakpointAction>(TargetBreakpointSpec.TargetBreakpointAction.class){

        protected Map<TargetBreakpointSpec.TargetBreakpointAction, ListenerMap.ListenerEntry<? extends TargetBreakpointSpec.TargetBreakpointAction>> createMap() {
            return new LinkedHashMap<TargetBreakpointSpec.TargetBreakpointAction, ListenerMap.ListenerEntry<? extends TargetBreakpointSpec.TargetBreakpointAction>>();
        }
    };

    protected static String indexBreakpoint(GdbBreakpointInfo info) {
        return PathUtils.makeIndex((long)info.getNumber());
    }

    protected static String keyBreakpoint(GdbBreakpointInfo info) {
        return PathUtils.makeKey((String)GdbModelTargetBreakpointSpec.indexBreakpoint(info));
    }

    public GdbModelTargetBreakpointSpec(GdbModelTargetBreakpointContainer breakpoints, GdbBreakpointInfo info) {
        super((AbstractDebuggerObjectModel)breakpoints.impl, (TargetObject)breakpoints, GdbModelTargetBreakpointSpec.keyBreakpoint(info), "BreakpointSpec");
        this.impl = breakpoints.impl;
        this.number = info.getNumber();
        this.info = info;
        this.impl.addModelObject(info, (TargetObject)this);
        this.changeAttributes(List.of(), Map.of("_container", breakpoints), "Initialized");
    }

    protected CompletableFuture<Void> init() {
        return this.updateInfo(this.info, this.info, "Created").exceptionally(ex -> {
            Msg.info((Object)((Object)this), (Object)"Initial breakpoint info update failed", (Throwable)ex);
            return null;
        });
    }

    public CompletableFuture<Void> delete() {
        return this.impl.gateFuture(this.impl.gdb.deleteBreakpoints(this.number));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getExpression() {
        return this.expression;
    }

    protected TargetBreakpointSpecContainer.TargetBreakpointKindSet computeKinds(GdbBreakpointInfo from) {
        switch (from.getType()) {
            case BREAKPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE});
            }
            case HW_BREAKPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.HW_EXECUTE});
            }
            case HW_WATCHPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.WRITE});
            }
            case READ_WATCHPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.READ});
            }
            case ACCESS_WATCHPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.READ, TargetBreakpointSpec.TargetBreakpointKind.WRITE});
            }
        }
        return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of();
    }

    public TargetBreakpointSpecContainer.TargetBreakpointKindSet getKinds() {
        return this.kinds;
    }

    public void addAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.actions.add((Object)action);
    }

    public void removeAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.actions.remove((Object)action);
    }

    protected CompletableFuture<GdbBreakpointInfo> getInfo(DebuggerObjectModel.RefreshBehavior refresh) {
        if (!refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            return CompletableFuture.completedFuture(this.impl.gdb.getKnownBreakpoints().get(this.number));
        }
        return this.impl.gdb.listBreakpoints().thenApply(__ -> this.impl.gdb.getKnownBreakpoints().get(this.number));
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.getInfo(refresh).thenCompose(i -> this.updateInfo(this.info, (GdbBreakpointInfo)i, "Refreshed"));
    }

    public CompletableFuture<Void> disable() {
        return this.impl.gateFuture(this.impl.gdb.disableBreakpoints(this.number));
    }

    public CompletableFuture<Void> enable() {
        return this.impl.gateFuture(this.impl.gdb.enableBreakpoints(this.number));
    }

    protected CompletableFuture<Void> updateInfo(GdbBreakpointInfo oldInfo, GdbBreakpointInfo newInfo, String reason) {
        if (newInfo.getType().isWatchpoint()) {
            return this.updateWptInfo(oldInfo, newInfo, reason);
        }
        return this.updateBktpInfo(oldInfo, newInfo, reason);
    }

    protected void updateAttributesFromInfo(String reason) {
        this.enabled = this.info.isEnabled();
        this.expression = this.info.getType() == GdbBreakpointType.CATCHPOINT ? this.info.getCatchType() : this.info.getOriginalLocation();
        this.kinds = this.computeKinds(this.info);
        this.display = this.computeDisplay();
        this.changeAttributes(List.of(), Map.of("_enabled", this.enabled, "_expression", this.expression, "_kinds", this.kinds, "_display", this.display), reason);
    }

    protected synchronized List<GdbModelTargetBreakpointLocation> setInfoAndComputeLocations(GdbBreakpointInfo oldInfo, GdbBreakpointInfo newInfo) {
        if (oldInfo != this.info) {
            Msg.error((Object)((Object)this), (Object)"Manager and model breakpoint info was/is out of sync!");
        }
        this.info = newInfo;
        List<GdbModelTargetBreakpointLocation> effectives = newInfo.getLocations().stream().filter(l -> !"<PENDING>".equals(l.getAddr())).map(this::getTargetBreakpointLocation).collect(Collectors.toList());
        this.breaksBySub.keySet().retainAll(effectives.stream().map(e -> e.loc.getSub()).collect(Collectors.toSet()));
        return effectives;
    }

    protected CompletableFuture<Void> updateBktpInfo(GdbBreakpointInfo oldInfo, GdbBreakpointInfo newInfo, String reason) {
        List<GdbModelTargetBreakpointLocation> locs = this.setInfoAndComputeLocations(oldInfo, newInfo);
        this.updateAttributesFromInfo(reason);
        this.setElements(locs, reason);
        return AsyncUtils.NIL;
    }

    protected CompletableFuture<Void> updateWptInfo(GdbBreakpointInfo oldInfo, GdbBreakpointInfo newInfo, String reason) {
        List<GdbModelTargetBreakpointLocation> locs = this.setInfoAndComputeLocations(oldInfo, newInfo);
        this.updateAttributesFromInfo(reason);
        assert (locs.size() == 1);
        return locs.get(0).initWpt().thenAccept(__ -> this.setElements(locs, reason));
    }

    protected GdbModelTargetBreakpointLocation findLocation(GdbModelTargetStackFrame frame) {
        for (GdbModelTargetBreakpointLocation bp : this.breaksBySub.values()) {
            if (!bp.loc.getInferiorIds().contains(frame.inferior.inferior.getId())) continue;
            return bp;
        }
        return null;
    }

    protected void breakpointHit(GdbModelTargetStackFrame frame, GdbModelTargetBreakpointLocation eb) {
        ((TargetBreakpointSpec.TargetBreakpointAction)this.actions.fire).breakpointHit((TargetBreakpointSpec)this, (TargetObject)frame.thread, (TargetStackFrame)frame, (TargetBreakpointLocation)eb);
    }

    public synchronized GdbModelTargetBreakpointLocation getTargetBreakpointLocation(GdbBreakpointLocation loc) {
        return this.breaksBySub.computeIfAbsent(loc.getSub(), i -> new GdbModelTargetBreakpointLocation(this, loc));
    }

    protected String addressFromInfo() {
        if (this.info.getAddress() != null) {
            return this.info.getAddress();
        }
        List<GdbBreakpointLocation> locs = this.info.getLocations();
        if (locs.isEmpty()) {
            return "<PENDING>";
        }
        if (locs.size() == 1) {
            String addr = locs.get(0).getAddr();
            if (addr == null) {
                return "<PENDING>";
            }
            return addr;
        }
        return "<MULTIPLE>";
    }

    protected String computeDisplay() {
        String enb = this.info.isEnabled() ? "y" : "n";
        String addr = this.addressFromInfo();
        String what = this.info.getWhat() == null ? "" : this.info.getWhat();
        switch (this.info.getType()) {
            case BREAKPOINT: 
            case HW_BREAKPOINT: 
            case HW_WATCHPOINT: 
            case READ_WATCHPOINT: 
            case ACCESS_WATCHPOINT: 
            case OTHER: {
                return String.format("%d %s %s %s %s %s", new Object[]{this.info.getNumber(), this.info.getTypeName(), this.info.getDisp(), enb, addr, what}).trim();
            }
            case CATCHPOINT: {
                return String.format("%d %s %s %s %s", new Object[]{this.info.getNumber(), this.info.getTypeName(), this.info.getDisp(), enb, what}).trim();
            }
            case DPRINTF: {
                return String.format("%d %s %s %s %s %s", new Object[]{this.info.getNumber(), this.info.getTypeName(), this.info.getDisp(), enb, addr, what}).trim();
            }
        }
        throw new AssertionError();
    }

    public String getDisplay() {
        return this.display;
    }

    public GdbModelTargetBreakpointContainer getContainer() {
        return (GdbModelTargetBreakpointContainer)this.parent;
    }
}

