/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbProcessThreadGroup;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetAttachable;
import agent.gdb.model.impl.GdbModelTargetSession;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetConfigurable;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="AvailableContainer", elementResync=TargetObjectSchema.ResyncMode.ALWAYS, attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetAvailableContainer
extends DefaultTargetObject<GdbModelTargetAttachable, GdbModelTargetSession>
implements TargetConfigurable {
    public static final String NAME = "Available";
    protected final GdbModelImpl impl;
    protected final Map<Integer, GdbModelTargetAttachable> attachablesById = new WeakValueHashMap();

    public GdbModelTargetAvailableContainer(GdbModelTargetSession session) {
        super((AbstractDebuggerObjectModel)session.impl, (TargetObject)session, NAME, "AvailableContainer");
        this.impl = session.impl;
        this.changeAttributes(List.of(), Map.of("_base", 10), "Initialized");
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.impl.gdb.listAvailableProcesses().thenAccept(list -> {
            List available;
            GdbModelTargetAvailableContainer gdbModelTargetAvailableContainer = this;
            synchronized (gdbModelTargetAvailableContainer) {
                available = list.stream().map(this::getTargetAttachable).collect(Collectors.toList());
            }
            this.setElements(available, "Refreshed");
        });
    }

    protected synchronized GdbModelTargetAttachable getTargetAttachable(GdbProcessThreadGroup process) {
        return this.attachablesById.computeIfAbsent(process.getPid(), i -> new GdbModelTargetAttachable(this.impl, this, process));
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (GdbModelTargetAttachable child : this.getCachedElements().values()) {
                        child.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

