/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbManager;
import agent.gdb.manager.evt.AbstractGdbCompletedCommandEvent;
import agent.gdb.manager.evt.GdbCommandRunningEvent;
import agent.gdb.manager.evt.GdbConsoleOutputEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadAndFrameId;
import org.apache.commons.text.StringEscapeUtils;

public class GdbConsoleExecCommand
extends AbstractGdbCommandWithThreadAndFrameId<String> {
    private final String command;
    private final Output to;
    private final CompletesWithRunning cwr;

    public GdbConsoleExecCommand(GdbManagerImpl manager, Integer threadId, Integer frameId, String command, Output to, CompletesWithRunning cwr) {
        super(manager, threadId, frameId);
        this.command = command;
        this.to = to;
        this.cwr = cwr;
    }

    @Override
    public GdbManagerImpl.Interpreter getInterpreter() {
        return GdbManagerImpl.Interpreter.MI2;
    }

    @Override
    public String encode(String threadPart, String framePart) {
        switch (this.getInterpreter()) {
            case CLI: {
                return this.command;
            }
            case MI2: {
                return "-interpreter-exec" + threadPart + framePart + " console \"" + StringEscapeUtils.escapeJava((String)this.command) + "\"";
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (this.getInterpreter() == GdbManagerImpl.Interpreter.CLI) {
            GdbConsoleOutputEvent out;
            return evt instanceof GdbConsoleOutputEvent && (out = (GdbConsoleOutputEvent)evt).getInterpreter() == GdbManagerImpl.Interpreter.CLI;
        }
        if (evt instanceof GdbCommandRunningEvent) {
            return this.cwr.handleRunning((GdbCommandRunningEvent)evt, pending);
        }
        if (evt instanceof AbstractGdbCompletedCommandEvent) {
            pending.claim(evt);
            return true;
        }
        if (evt instanceof GdbConsoleOutputEvent) {
            GdbConsoleOutputEvent out = (GdbConsoleOutputEvent)evt;
            if (out.getInterpreter() == GdbManagerImpl.Interpreter.MI2 && ">".equals(out.getOutput().trim()) && !this.command.trim().startsWith("ec")) {
                this.manager.injectInput(GdbManagerImpl.Interpreter.MI2, "end\n");
                this.manager.synthesizeConsoleOut(GdbManager.Channel.STDERR, "Ghidra GDB Agent: Multi-line / follow-up input is not currently supported. I just typed 'end' for you.\n");
            }
            if (this.to == Output.CAPTURE && out.getInterpreter() == this.getInterpreter()) {
                pending.steal(evt);
            }
        }
        return false;
    }

    @Override
    public String complete(GdbPendingCommand<?> pending) {
        if (this.getInterpreter() == GdbManagerImpl.Interpreter.CLI) {
            return null;
        }
        pending.checkCompletion(this.cwr.completionClass);
        if (this.to == Output.CONSOLE) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (GdbConsoleOutputEvent out : pending.findAllOf(GdbConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        return builder.toString();
    }

    public Output getOutputTo() {
        return this.to;
    }

    @Override
    public boolean isFocusInternallyDriven() {
        return this.to == Output.CAPTURE;
    }

    public static enum Output {
        CONSOLE,
        CAPTURE;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CompletesWithRunning {
        CANNOT(AbstractGdbCompletedCommandEvent.class){

            @Override
            boolean handleRunning(GdbCommandRunningEvent evt, GdbPendingCommand<?> pending) {
                return false;
            }
        }
        ,
        CAN(AbstractGdbCompletedCommandEvent.class){

            @Override
            boolean handleRunning(GdbCommandRunningEvent evt, GdbPendingCommand<?> pending) {
                pending.claim(evt);
                return true;
            }
        }
        ,
        MUST(GdbCommandRunningEvent.class){

            @Override
            boolean handleRunning(GdbCommandRunningEvent evt, GdbPendingCommand<?> pending) {
                pending.claim(evt);
                return true;
            }
        };

        private final Class<? extends AbstractGdbCompletedCommandEvent> completionClass;

        private CompletesWithRunning(Class<? extends AbstractGdbCompletedCommandEvent> completionClass) {
            this.completionClass = completionClass;
        }

        abstract boolean handleRunning(GdbCommandRunningEvent var1, GdbPendingCommand<?> var2);
    }
}

